#!/bin/sh
set -x

#####
#	this adds wavenumebr integration solutions
#	and is careful to correctly update the current W.WCL
#####



#####
#	shell script for creating the eigenfunction
#	Green s function files for source inversion
#####

#####
#	define the DESTINATION DIRECTORY
#	
#	PATH is high level path which must exist
#	MODEL is the model directory which will be created if required
#	PMIN, PMAX are the periods for which eigenfunctions are
#		to be created
#
#####

DEST=${GREENDIR}
#####
#       Since this script is already in the directory
#       /home/rbh/PROGRAMS.310t/CUS which already exists
#       redefine the DEST to
#
#####
MODEL=CUS.REG
PMIN=4.0
PMAX=100.0
Mname=CUS.mod

if [ ! -d ${DEST}/${MODEL} ]
then
	echo Creating the Directory ${DEST}/${MODEL}
	mkdir ${DEST}/${MODEL}
fi

#####
#	create the model subdirectory
#####

if [ ! -d ${DEST}/${MODEL}/Model ]
then
	echo Creating the Directory ${DEST}/${MODEL}/Model
	mkdir ${DEST}/${MODEL}/Model
fi

#####
#	create the surface-wave control directory
#####

if [ ! -d ${DEST}/${MODEL}/SW ]
then
	echo Creating the Directory ${DEST}/${MODEL}/SW
	mkdir ${DEST}/${MODEL}/SW
fi

#####
#	define the earth model here - the many layers permit the
#	specification of eigenfunctions with depth - should
#	rewrite slegn96 and regn96 to permit layer insertion
#	this way the simple model can be used to get disperion curves
#
#	ham96.mod is the simple model for for wavenumber integration
#	dham96.mod is the detailed model for eigenfunctions
#####

cp ${Mname} ${DEST}/${MODEL}/Model/${Mname}
cp d${Mname} ${DEST}/${MODEL}/Model/d${Mname}

#####
#	go to the working directory
#####

cd ${DEST}/${MODEL}/SW

#####
#	create the surface wave data sets
#####

sprep96 -PMIN ${PMIN} -PMAX ${PMAX} -M ../Model/d${Mname} -L -R -NMOD 40
sdisp96 
sregn96 -DER 
slegn96 -DER 
######
#	Uncomment this if you want to see the eigenfunctions
#####
sdpder96 -L -TXT
sdpder96 -R -TXT
#####
#	create the eigenfunction for dispersion
#####
sprep96 -PMIN ${PMIN} -PMAX ${PMAX} -M ../Model/d${Mname} -L -R -NMOD 1
sdisp96 
sregn96 
slegn96  

#####
#	now systematically create the wavenumber integration Green s functions
#####

#####
#	return to the main directory
#####
cd ${DEST}/${MODEL}

#####
#	Now begin the wavenumber integration run
#	remove the W.CTL file
#####
#rm -f W.CTL


for HS in \
	0.5 \
	   01 02 03 04 05 06 07 08 09 \
	10 11 12 13 14 15 16 17 18 19 \
	20 21 22 23 24 25 26 27 28 29 \
	30 31 32 33 34 35 36 37 38 39 \
	40 41 42 43 44 45 46 47 48 49 \
	50
do

#####
#	define the directory name
#####

case $HS in
	0.5) DIRNAME=0005 ;;
	*)   DIRNAME=0${HS}0;;
esac

if [ ! -d  ${DIRNAME} ]
then
	echo creating the Green s Function depth directory 
	echo $DIRNAME for depth $HS
	mkdir ${DIRNAME}
fi

cd $DIRNAME
#####
#	compute the Green's functions for different distances
#	To save computational time, the number of data points will
#	be controlled by the distance
#
#	ALSO CANNOT HAVE MORE THAN 500 RECEIVERS SO BE CAREFUL OF THE
#	number is distances in the DFILE TABULATION
#####


DT=0.25
VRED=8
NPTS=4096
T0=-5
rm -f dfile

for DIST in \
	0800 0810 0820 0830 0840 0850 0860 0870 0880 0890 \
	0900 0910 0920 0930 0940 0950 0960 0970 0980 0990 \
	1000 1010 1020 1030 1040 1050 1060 1070 1080 1090 \
	1100 1110 1120 1130 1140 1150 1160 1170 1180 1190 \
	1200 1210 1220 1230 1240 1250 1260 1270 1280 1290 \
	1300 1310 1320 1330 1340 1350 1360 1370 1380 1390 \
	1400 1410 1420 1430 1440 1450 1460 1470 1480 1490 \
	1500 1510 1520 1530 1540 1550 1560 1570 1580 1590 \
	1600 1610 1620 1630 1640 1650 1660 1670 1680 1690 \
	1700 1710 1720 1730 1740 1750 1760 1770 1780 1790 \
	1800 1810 1820 1830 1840 1850 1860 1870 1880 1890 \
	1900 1910 1920 1930 1940 1950 1960 1970 1980 1990 \
	2000 2010 2020 2030 2040 2050 2060 2070 2080 2090 \
	2100 2110 2120 2130 2140 2150 2160 2170 2180 2190


do
cat >> dfile << EOF
$DIST $DT $NPTS $T0 $VRED
EOF

done
wc dfile
#####
#	do the wavenumber integration
#####
sprep96 -M ../Model/${Mname} -d dfile -HS ${HS} -HR 0.0 -EQEX -L -R -NMOD 40
sdisp96
sregn96
slegn96
spulse96 -V -p -l 1 -EQ -d dfile -2 | f96tosac -G

#####
#       now that all computations are done, create the final
#       W.CTL since the above efforts do not match the naming
#       created by the FORTRAN code in f96tosac
#
######
        ../MKW > W.CTL

#####
#	return to upper level directory
#####

cd ..

done

