char *help_default [] = {
"\n",
"\n",
"GSAC Command Reference Manual                                HELP\n",
"\n",
"SUMMARY:\n",
"     List syntax for GSAC command\n",
"\n",
"     Help [command]\n",
"\n",
"     where command is one or more of the following:\n",
"\n",
"     ABS                              Get absolute value of trace\n",
"     AGC                              AGC traces\n",
"     ADD                              Add constant to each trace\n",
"     ADDF                             Add Files in memory\n",
"     BACKGROUND                       Set trace background color\n",
"     BD           BEGINDEVICES        Begin graphics\n",
"     BG           BEGINGRAPHICS       Begin graphics\n",
"     BOXCAR                           Convolve with unit area boxcar\n",
"     BP           BANDPASS            Bandpass filter\n",
"     BR           BANDREJ             Bandreject filter\n",
"     CD                               change working directory\n",
"     CH           CHNHDR              Change header\n",
"     COLOR                            Control plotting colors\n",
"     CON          CONVOLVE            Convolve traces\n",
"     COR          CORRELATE           Correlate traces\n",
"     CUT                              Cut trace as it is read\n",
"     CUTERR                           Control CUT\n",
"     DEC          DECIMATE            Decimate trace\n",
"     DIF                              Differentiate traces numerically\n",
"     DIV                              Divide each trace by constant\n",
"     DIVF                             Divide Files in memory\n",
"     ECHO                             Echo a line of text to the terminal\n",
"     ENV          ENVELOPE            Get trace envelope\n",
"     EXP                              Exponentiate traces\n",
"     EXP10                            Raise traces to power of 10\n",
"     FFT          DFT                 Take Fourier Transform\n",
"     FG           FUNCGEN             Generate an impulse function\n",
"     FILEID                           Controls the plot legend\n",
"     FILT         FILTER              Apply or remove instrument response\n",
"     GRID                             Control plot grid for x- and y-axes\n",
"     H            HELP                Print this help list\n",
"     HILBERT                          Get Hilbert transform of a trace\n",
"     HIS          HISTORY             Display readline command history\n",
"     HOLD                             Permit plot overlay in current frame\n",
"     HP           HIGHPASS            Highpass filter\n",
"     INTERP       INTERPOLATE         Resample traces\n",
"     INT                              Integrate traces\n",
"     LH           LISTHDR             List header\n",
"     LINLIN                           lin-lin plot for plot, plotpk\n",
"     LINLOG                           lin-log plot for plot, plotpk\n",
"     LOG                              Take natural logarithm of trace\n",
"     LOG10                            Take base 10 logarithm of trace\n",
"     LP           LOWPASS             Lowpass filter\n",
"     MAP                              Produce GMT map\n",
"     MAP5                             Produce GMT map (V5.0 and later)\n",
"     MARKT        MARKTIMES           Marks velocity times in plot\n",
"     MT           MOMENTTENSOR        Generate seismogram for moment tensor\n",
"     MUL                              Multiply each trace by constant\n",
"     MULF                             Multiply Files in memory\n",
"     OUTCSV                           Output timeseries as spreadsheet CSV\n",
"     P1           PLOT1               Plot trace (all part of PLOT)\n",
"     P            PLOT                Plot trace\n",
"     P2           PLOT2               Plot trace\n",
"     PAUSE                            Pause a specified number of seconds\n",
"     PCTL                             Control time-domain plots\n",
"     PSP          PLOTSP              Plot trace spectra\n",
"     PSPPK        PLOTSPPK            Interactive spectra pick\n",
"     PRS          PLOTRECORDSECTION   Plot record section\n",
"     PPK          PLOTPK              Interactive trace plot\n",
"     QDP                              Decimate factor for screen plot\n",
"     Q            QUIT                Exit GSAC\n",
"     R            READ                Read SAC files\n",
"     REFR         REFRACTION          Enter Refraction Mode\n",
"     REV          REVERSE             Reverse Time Series\n",
"     RH           READHDR             Read header\n",
"     RI           RICKER              Convolve with Ricker wavelet\n",
"     RMEAN                            Remove mean\n",
"     ROT          ROTATE              Rotate horizontal components\n",
"     ROT3         ROTATE3             Rotate three components to form R T Z\n",
"     RTR          RTREND              Remove trend\n",
"     SGN                              1BIT digitization\n",
"     SHIFT                            Shift trace in time\n",
"     SM           SMOOTH              Apply a smoothing operator\n",
"     SORT                             Sort traces\n",
"     SQR                              Square traces\n",
"     SQRT                             Square root of  traces\n",
"     STACK                            Stack traces\n",
"     SUB                              Subtract constant from each trace\n",
"     SUBF                             Subtract Files in memory\n",
"     SYNC         SYNCHRONIZE         Synchronize trace timing\n",
"     TAPER                            Apply a symmetric taper to  traces\n",
"     TITLE                            Plot title\n",
"     TRANS        TRANSFER            Apply or remove instrument response\n",
"     TRAPEZOID                        Convolve with unit area trapezoid\n",
"     TRIANGLE                         Convolve with unit area triangle\n",
"     VERSION                          Print version number\n",
"     W            WRITE               Read SAC files\n",
"     WSP          WRITESPEC           Write spectra\n",
"     WH           WRITEHDR            Write header\n",
"     WHITEN                           Whiten signal\n",
"     XGRID                            Control x-axis grid\n",
"     XLIM                             Set time axis limits for trace plot\n",
"     XLIN                             Linear x-axis for plot, plotpk\n",
"     XLOG                             Logarithmic x-axis for plot, plotpk\n",
"     YGRID                            Control y-axis grid\n",
"     YLIM                             Set y-axis scaling for plot1\n",
"     YLIN                             Linear y-axis for plot, plotpk\n",
"     YLOG                             Logarithmic y-axis for plot, plotpk\n",
""
};

char *help_abs [] = {
"\n",
"\n",
"GSAC Command Reference Manual                                 ABS\n",
"\n",
"SUMMARY:\n",
"     Take the absolute value of each data point\n",
"\n",
"     ABS\n",
"INPUT:\n",
"\n",
"DESCRIPTION:\n",
"     This determines the absolute value of each point of the trace.\n",
"\n",
"SEE ALSO:\n",
"     SQR, SQRT\n",
""
};

char *help_add[] = {
"\n",
"\n",
"GSAC Command Reference Manual                                 ADD\n",
"\n",
"SUMMARY:\n",
"     Add a constant to  all SAC data files in  memory.\n",
"\n",
"     ADD [v]\n",
"\n",
"INPUT:\n",
"     [v]      : constant to be added to all files\n",
"\n",
"SAC COMPATIBILITY:\n",
"     SAC  permits  an  extended syntax that permits applying different\n",
"     constants to respective files in memory. We have not  implemented\n",
"     this complexity.\n",
"DEFAULT\n",
"     ADD 0\n",
"\n",
"SEE ALSO\n",
"     SUB, MUL, DIV\n",
""
};

char *help_addf[] = {
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                                ADDF\n",
"\n",
"SUMMARY:\n",
"     Add Files in memory\n",
"\n",
"     ADDF  [Master n] [ Suffix suffix ] [ Default ]\n",
"\n",
"INPUT:\n",
"     Master         :  Trace uses as master trace. Default is 0, which\n",
"     is the first in memory.\n",
"     Suffix suffix : The traces are renamed and the original traces in\n",
"        memory are overwritten to be of the form\n",
"         [STA2][CMP2]_[STA1][CMP1].suffix. The default  value  of  the\n",
"        suffix is '.add'\n",
"\n",
"DESCRIPTION:\n",
"     This  adds  the  master trace to all traces  in memory. After the\n",
"     addition   operation,   the   files   are   named   as    follow:\n",
"     [STA2][CMP2]_[STA1][CMP1].suffix  Beware  that nothing is done to\n",
"     the original header other than to reset the start and  end  times\n",
"     since  the  output  trace   is  only  for  the common overlapping\n",
"     absolute time window.\n",
"\n",
"HEADER CHANGES\n",
"     DEPMAX, DEPMIN, DEPMEN, NPTS, B, O\n",
"\n",
"EXAMPLES:\n",
"DEFAULT:\n",
"     ADDF MASTER 0 Suffix .add\n",
"SEE ALSO\n",
"     SUBF, MULF, DIVF\n",
""
};

char *help_dagc[] = {
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                                 AGC\n",
"\n",
"SUMMARY:\n",
"     AGC traces\n",
"\n",
"     AGC W window\n",
"\n",
"INPUT:\n",
"     W window : Define the averaging window in seconds\n",
"\n",
"DESCRIPTION:\n",
"     This  routine  applies an AGC operator to the trace such that the\n",
"     mean signal amplitude is near unity. The operator is obtained  by\n",
"     using a running average of the absolute value of the trace.\n",
"EXAMPLES:\n",
"\n",
"HEADER VALUES SET:\n",
"     DEPMAX, DEPMIN and DEPMEN are updated.\n",
"\n",
"SEE ALSO\n",
""
};

char *help_back[] = {
"\n",
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                          BACKGROUND\n",
"\n",
"SUMMARY:\n",
"     Set trace background color\n",
"\n",
"     BACKGROUND [ ON | OFF ] [ Color color_int ] [ DEFAULT ]\n",
"\n",
"INPUT:\n",
"     ON        : turn background color on\n",
"   OFF       : turn background color off\n",
"   Color  Color_int  :  set  the color - default value = 0; An integer\n",
"        between 0 and 1100. 0 is always background of screen, 1 is the\n",
"        screen foreground. for color displays 2 = Red, 3= Green,  4  =\n",
"        Blue etc. 1000 to 1100 is a transition from red to blue.\n",
"DESCRIPTION:\n",
"     Set  the  background  display  for the plots.  Note this does not\n",
"     change the frame background.\n",
"EXAMPLES:\n",
"\n",
"DEFAULT\n",
"     BACKGROUND OFF\n",
"SEE ALSO\n",
""
};

char *help_bp[] = {
"\n",
"\n",
"GSAC Command Reference Manual                            BANDPASS\n",
"\n",
"SUMMARY:\n",
"     BandPass filter traces\n",
"\n",
"     BandPass [options]\n",
"\n",
"     where options is one or more of the following:\n",
"\n",
"     [Butter  | BEssel | C1 ] [ Corner fc ] [ Npoles npoles ] [ Passes\n",
"     npass] [ Tranbw tranbw ] [ Atten atten ]\n",
"\n",
"INPUT:\n",
"     Butter   : Butterworth filter (default)\n",
"     BEssel   : Bessel filter\n",
"     C1       : Chebyshev Type I filter\n",
"     Corner   : Corner frequencies (R) range 0 - Nyquist\n",
"     Npoles   : Number of poles  (I) range 1 - 10\n",
"     Passes   : Number of passes (I) range 1 - 2\n",
"     Tranbw   : Chebyshev transition bandwidth fraction (0.3 default)\n",
"     Atten    : Chebyshev stop band attenuation (30 default)\n",
"\n",
"DESCRIPTION:\n",
"     Highpass filter using a BI-LINEAR Z-transformation implementation\n",
"     of a highpass filter. A bi-linear method is chosen since this  is\n",
"     easily  implemented  algebraically.  Passes  =  1  gives a causal\n",
"     filter while Passes = 2 gives a  zero-phase  filter  with  a  6db\n",
"     point at the corner frequency.\n",
"\n",
"     The lowpass filter design of the Chebyshev Type 1 filter is based\n",
"     on  the  information  in   Hamming  (1997)  equation (13.5.4) and\n",
"     Figure 13.6.1,  This  filter  attempts  to  approximate  a  sharp\n",
"     lowpass filter. In reality a transition band is defined by Fp and\n",
"     Fs,  where  Fp  is  the  lowpass  corner  frequency and Fs is the\n",
"     stopband, where Fs = (1 + tranbw)*Fp.  The amplitude level of the\n",
"     stop band (f > Fs) is 1/atten.  Actual implementation requires  a\n",
"     parameter  epsilon,  eps, which defines the lowpass ripple, which\n",
"     varies between 1 and 1/sqrt(1 + eps*eps).\n",
"          Hamming, Richard W. (1997). Digital Filters  (3rd  edition),\n",
"          Dover Publications, 296 pp, ISBN 048665088X\n",
"     Given npoles and eps, the poles and zeros are given by\n",
"          http://www.answers.com/topic/chebyshev-filter\n",
"     The correct normalization amplitude together with poles and zeros\n",
"     is given in\n",
"          Digital  Filter  Designers  Handbook with C++ algorithms, C.\n",
"          Britton Rorabaugh 2nd Edition, McGraw Hill, New York, 479 pp\n",
"          1997  Chapter 5\n",
"\n",
"EXAMPLES:\n",
"     Bandpass with corner frequencies at 1  and  10  Hz,  zero  phase,\n",
"     2-pole\n",
"     BP BUTTER C 1 10 P 2 NP 2\n",
"\n",
"HEADER VALUES SET\n",
"     USER1  =  permin,  USER2=permax,  where permin=1.0/(filt_fh), and\n",
"     permax= 1.0/(filt_fl) for use by sacmft96 and sacpom96\n",
"SEE ALSO\n",
"     LOWPASS, HIGHPASS, BANDREJECT\n",
""
};

char *help_br[] = {
"\n",
"\n",
"GSAC Command Reference Manual                          BANDREJECT\n",
"\n",
"SUMMARY:\n",
"     BandReject filter traces\n",
"\n",
"     BandReject [options]\n",
"\n",
"     where options is one or more of the following:\n",
"\n",
"     [Butter  | BEssel | C1 ] [ Corner fc ] [ Npoles npoles ] [ Passes\n",
"     npass] [ Tranbw tranbw ] [ Atten atten ]\n",
"\n",
"INPUT:\n",
"     Butter   : Butterworth filter\n",
"     BEssel   : Bessel filter\n",
"     C1       : Chebyshev Type I filter\n",
"     Corner   : Corner frequencies (R) range 0 - Nyquist\n",
"     Npoles   : Number of poles  (I) range 1 - 10\n",
"     Passes   : Number of passes (I) range 1 - 2\n",
"     Tranbw   : Chebyshev transition bandwidth fraction (0.3 default)\n",
"     Atten    : Chebyshev stop band attenuation (30 default)\n",
"\n",
"DESCRIPTION:\n",
"     Highpass filter using a BI-LINEAR Z-transformation implementation\n",
"     of a highpass filter. A bi-linear method is chosen since this  is\n",
"     easily  implemented  algebraically.  Passes  =  1  gives a causal\n",
"     filter while Passes = 2 gives a  zero-phase  filter  with  a  6db\n",
"     point at the corner frequency.\n",
"\n",
"     The lowpass filter design of the Chebyshev Type 1 filter is based\n",
"     on  the  information  in   Hamming  (1997)  equation (13.5.4) and\n",
"     Figure 13.6.1,  This  filter  attempts  to  approximate  a  sharp\n",
"     lowpass filter. In reality a transition band is defined by Fp and\n",
"     Fs,  where  Fp  is  the  lowpass  corner  frequency and Fs is the\n",
"     stopband, where Fs = (1 + tranbw)*Fp.  The amplitude level of the\n",
"     stop band (f > Fs) is 1/atten.  Actual implementation requires  a\n",
"     parameter  epsilon,  eps, which defines the lowpass ripple, which\n",
"     varies between 1 and 1/sqrt(1 + eps*eps).\n",
"          Hamming, Richard W. (1997). Digital Filters  (3rd  edition),\n",
"          Dover Publications, 296 pp, ISBN 048665088X\n",
"     Given npoles and eps, the poles and zeros are given by\n",
"          http://www.answers.com/topic/chebyshev-filter\n",
"     The correct normalization amplitude together with poles and zeros\n",
"     is given in\n",
"          Digital  Filter  Designers  Handbook with C++ algorithms, C.\n",
"          Britton Rorabaugh 2nd Edition, McGraw Hill, New York, 479 pp\n",
"          1997  Chapter 5\n",
"\n",
"EXAMPLES:\n",
"     Bandreject with corner frequencies at 1 and 10  Hz,  zero  phase,\n",
"     2-pole\n",
"          BR BUTTER C 1 10 P 2 NP 2\n",
"\n",
"SEE ALSO\n",
"     LOWPASS, HIGHPASS, BANDPASS\n",
""
};

char *help_bg[] = {
"\n",
"\n",
"GSAC Command Reference Manual                       BEGINGRAPHICS\n",
"\n",
"SUMMARY:\n",
"     Initialize the graphics device\n",
"\n",
"     BeginGraphics [options] BeginDevices [options]\n",
"\n",
"     where options is one or more of the following:\n",
"\n",
"     [X  |  W  |  Plt  ]  [ GEOM width height ] [ REVERSE ] [ GRAY ] [\n",
"     COLOR]\n",
"\n",
"INPUT:\n",
"     X or W     : Interactive windows display\n",
"     Plt        : Generate external Calplot PLT file\n",
"     [These are only useful if nothing has been plotted on  screen  in\n",
"        window mode]\n",
"     GEOM height width : set screen window height and width\n",
"     GRAY       : use gray scale instead of color\n",
"     COLOR      : use color scale instead of gray\n",
"     REVERSE    : invert the foreground and background\n",
"DESCRIPTION:\n",
"     This  initializes  the graphics. For an interactive display under\n",
"     X11 or Windows, the graphics display is initialized at  the  time\n",
"     of the first plot command (Plot Plot1 PlotPK).\n",
"\n",
"     Invocation  of  the  PLT  option causes the creation of a CALPLOT\n",
"     plot file of the form Pxxxx.PLT,  where  the  xxxx  is  a  unique\n",
"     number incremented each time the BG PLT is invoked\n",
"\n",
"     For windows plot, the screen geometry and color map is defined by\n",
"     the  external environment parameter PLOTXVIG. One may define this\n",
"     variable or override the  shell  version  through  this  command.\n",
"     However,  because  of low level problems of color maps and malloc\n",
"     s, the window definition can only per performed  ONCE  BEFORE  an\n",
"     actual screen plot is made.\n",
"\n",
"SAC COMPATIBILITY:\n",
"     SUNWINDOWS  SGF  and  Tektronix  are  not  supported.  A separate\n",
"     Pnnn.PLT CALPLOT binary file  is  created  for  each  plot  made.\n",
"     P0001.PLT is always the first plot file. To convert to PostScript\n",
"     use plotnps < Pxxxx.PLT ; to convert to an EPS file, use\n",
"     cat  Pxxxx.PLT | reframe -Npage_number -O | plotnps -EPS -F7 -W10\n",
"        > epsfile\n",
"\n",
"SEE ALSO\n",
""
};

char *help_boxcar[] = {
"\n",
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                              BOXCAR\n",
"\n",
"SUMMARY:\n",
"     Convolve with unit area boxcar\n",
"\n",
"     BOXCAR Width width\n",
"\n",
"INPUT:\n",
"     Width  width  :  the length of the boxcar function rounded to the\n",
"     next sample interval.\n",
"DESCRIPTION:\n",
"     his routine convolves all traces  in  memory  with  a  unit  area\n",
"     isosceles triangular pulse.  This command is equivalent to\n",
"\n",
"             TRAPEZOID WIDTH 0.0 width 0.0\n",
"\n",
"     This acts as a lowpass filter.\n",
"\n",
"     If Width < DELTA, nothing is done.\n",
"EXAMPLES:\n",
"\n",
"SEE ALSO\n",
"     TRAPEZOID, TRIANGLE, RICKER\n",
""
};

char *help_cd [] = {
"\n",
"\n",
"GSAC Command Reference Manual                                  CD\n",
"\n",
"SUMMARY:\n",
"     Change the current working directory\n",
"\n",
"     CD path\n",
"\n",
"INPUT:\n",
"     path     : path to the next directory\n",
"\n",
"DESCRIPTION:\n",
"     This  changes  the working directory. If there are already traces\n",
"     in memory and one decides to do a write, the  operation  may  not\n",
"     work if the file path is no longer valid from the new directory\n",
"\n",
"SEE ALSO\n",
""
};

char *help_ch [] = {
"\n",
"\n",
"GSAC Command Reference Manual                        CHANGEHEADER\n",
"\n",
"SUMMARY:\n",
"     Change header values in memory\n",
"\n",
"     ChangeHeader [ name value ]\n",
"\n",
"INPUT:\n",
"     name     : SAC header name\n",
"     value    : New value for that header variable\n",
"\n",
"DESCRIPTION:\n",
"     This   commands  lets  one  change  many  of  the  header  values\n",
"     associated with a trace.  If more than one trace  is  in  memory,\n",
"     then  all  header  variables  are updated.  The following listing\n",
"     gives the header names that can be changed:\n",
"\n",
"     Reals: DELTA, DEPMIN, DEPMAX, SCALE, ODELTA, B, E, O, A, FMT, T0,\n",
"     T1, T2, T3, T4, T5, T6, T7, T8, T9, F, RESP0, RESP1, RESP2,\n",
"     RESP3, RESP4, RESP5, RESP6, RESP7, RESP8, RESP9, STLA, STLO,\n",
"     STEL, STDP, EVLA, EVLO, EVEL, EVDP, USER0, USER1, USER2, USER3,\n",
"     USER4, USER5, USER6, USER7, USER8, USER9, DIST, AZ, BAZ, GCARC,\n",
"     SB, SDELTA, DEPMEN, CMPAZ, CMPINC, XMINIMUM, XMAXIMUM, YMINIMUM,\n",
"     YMAXIMUM, ADJTM\n",
"\n",
"     Integers: NZYEAR, NZJDAY, NZHOUR, NZMIN, NZSEC, NZMSEC, N NINF,\n",
"     NHST, NPTS, NSNPTS, NSN, NXSIZE, NYSIZE, IFTYPE, IDEP, IZTYPE,\n",
"     IINST, ISTREG, IEVREG, IEVTYP, IQUAL, ISYNTH, IHDR12, IHDR13,\n",
"     IHDR14, IHDR15, IHDR16, IHDR17, IHDR18, IHDR19, IHDR20, LPSPOL,\n",
"     LOVROK, LCALDA,\n",
"\n",
"     Strings: KSTNM, KEVNM, KHOLE, KO, KA, KT0, KT1, KT2, KT3, KT4,\n",
"     KT5, KT6, KT7, KT8, KT9, KF, KUSER0, KUSER1, KUSER2, KCMPNM,\n",
"     KNETWK, KDATRD, KINST\n",
"\n",
"     NOTE THAT ANY ATTEMPT TO CHANGE NVHDR or NPTS IS IGNORED\n",
"\n",
"     Because SAC permits something like\n",
"\n",
"        ch o 10\n",
"\n",
"        ch o gmt 2004 123 10 20 30 500\n",
"\n",
"     The  command  parsing  is  complicated.  GSAC  handles  this   by\n",
"     internally concatenating the o and gmt to form the new GSAC ogmt.\n",
"     GMT introduces the following time commands:\n",
"\n",
"     Setting  GMT Time: OGMT, AGMT, T0GMT, T1GMT, T2GMT, T3GMT, T4GMT,\n",
"     T5GMT, T6GMT, T7GMT, T8GMT, T9GMT\n",
"\n",
"     Also since it is often inconvenient to determine the day  of  the\n",
"     year, GSAC permits entries of the form\n",
"\n",
"        ch OCAL 2004 05 02 10 20 30 500\n",
"\n",
"        ch o cal 2004 05 02 10 20 30 500\n",
"\n",
"     Setting  Calendar  Time:  OCAL, ACAL, T0CAL, T1CAL, T2CAL, T3CAL,\n",
"     T4CAL, T5CAL, T6CAL, T7CAL, T8CAL, T9CAL\n",
"\n",
"     NOTE You can assign values to USER1 and USER2 if  followed  by  a\n",
"     WRITEHEADER. However if you follow by a WRITE, then the USER1 and\n",
"     USER2  fileids  will  be  the minimum and maximum filter periods.\n",
"     THIS WAS A DESIGN DECISION.\n",
"\n",
"SEE ALSO\n",
"     WriteHeader, ListHeader\n",
""
};

char *help_color [] = {
"\n",
"\n",
"GSAC Command Reference Manual                               COLOR\n",
"\n",
"SUMMARY:\n",
"     Controls color of trace plots\n",
"\n",
"     COLOR [ON|OFf] [options] where options is on of the following:\n",
"          DEFAULT RAINBOW LIST list_entries\n",
"INPUT:\n",
"     ON        : Enable color output\n",
"     OFf        :  Disable  color  output  -  traces  will  be CALPLOT\n",
"        foreground\n",
"     DEFAULT   : Use the default color sequence\n",
"     LIST      : A user specified list for the alternating  colors  is\n",
"        used  which  are  one  of  the following keywords: BLAck, REd,\n",
"        Green BLUe, ORange, Cyan, Yellow\n",
"     RAINBOW   : A selection of colors from RED to BLUE (or  light  to\n",
"        dark in gray scale), with colors chosen according to the trace\n",
"        number. Two traces will plot as RED and BLUE.\n",
"DESCRIPTION:\n",
"     This  permits  different  traces  to  be  plotted  with different\n",
"     colors.  color BLACK is actually the foreground color. By default\n",
"     this  is  BLACK  in  CALPLOT,  but  if  the  interactive  display\n",
"     environment    is    set    by   the   SHELL   command    'export\n",
"     PLOTXVIG=:-K:-I:' under the 'bash shell', the background will  be\n",
"     black and the foreground white.\n",
"     The RAINBOW option indicates that the traces will be plotted in a\n",
"        progression from RED to BLUE, as in a rainbow.\n",
"\n",
"SEE ALSO\n",
""
};

char *help_conv[] = {
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                            CONVOLVE\n",
"\n",
"SUMMARY:\n",
"     Convolve traces\n",
"\n",
"     CONvolve    Zero    [B|O|A|T0|T1|T2|T3|T4|T5|T6|T7|T8|T9]    File\n",
"     external_sac_file [Suffix suffix]\n",
"\n",
"INPUT:\n",
"     Zero            : Specify marker to define the zero time for  the\n",
"        external  pulse.  Since  the  external  pulse  may  have  been\n",
"        delayed, one marker must be set. The default  is  the  O  (oh)\n",
"        marker\n",
"     File  FILE        :  Name of external file containing the impulse\n",
"        response of the filter\n",
"     Suffix   suffix : Suffix to be  appended  to  the  file  name  in\n",
"        memory  after  convolution.The  default value of the suffix is\n",
"        '.con' After the convolution operation, the files are named as\n",
"        follow: original_name{suffix}, e.g.,  SLMNMBHZ.con.\n",
"\n",
"DESCRIPTION:\n",
"     All traces in  memory  are  convolved  with  the  external  trace\n",
"     specified on the command line. with the master trace is computed.\n",
"     If  the   trace  in memory is called x, and the external trace is\n",
"     called h, the convolution is defined as\n",
"       INT x(tau) h(t - tau) dtau\n",
"     where dtau is the sample interval.\n",
"     The input trace is linearly interpolated to match the sampling of\n",
"        the traces in memory. The convolution is  implemented  in  the\n",
"        time  domain  to  avoid discrete Fourier transform (DFT) wrap-\n",
"        around problems.\n",
"     The zero lag time for the external trace, h(t), is  specified  on\n",
"        the  command  line as one of the B, O, A, T0, ..., T9 markers,\n",
"        which  must  be  set  in  the  external  file.  Otherwise  the\n",
"        convolution will not occur.\n",
"     Note  the  only  the  DEPMAX, DEPMIN and DEPMEN header values are\n",
"        changed for the traces in memory.  The zero  marker  from  the\n",
"        external trace is not written on the the headers of the traces\n",
"        in memory.\n",
"DEFAULT\n",
"     Align O Suffix .con\n",
"SEE ALSO\n",
""
};

char *help_corr[] = {
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                           CORRELATE\n",
"\n",
"SUMMARY:\n",
"     Compute auto- and cross correlation of traces\n",
"\n",
"     CORrelate  [Master n] [Number n] [Length ON|OFF|Window] [Default]\n",
"     [Suffix suffix] [Reverse] [2]\n",
"\n",
"INPUT:\n",
"     Master   : Trace uses as master trace. Default if first in memory\n",
"     Number   : Number of correlation windows to be used. The original\n",
"        trace is split into Number segments; the cross-correlation  is\n",
"        determined for each segment and then summed.\n",
"     Length    :  The  original time series is broken into segments of\n",
"        Window seconds; the cross-correlation is determined  for  each\n",
"        segment and then summed.\n",
"     Suffix   suffix :  The traces are renamed and the original traces\n",
"        in memory are overwritten to be of the form\n",
"         [STA2][CMP2]_[STA1][CMP1].suffix.  The  default  value of the\n",
"        suffix is '.cor'\n",
"     2        : Use  a  double  length  time  series  to  prevent  FFT\n",
"        periodicity.  Output length is not changed\n",
"     Reverse  : Instead of computing INT x(tau)y(t + tau) dtau compute\n",
"        INT y(tau)x(t + tau) dtau, where x is the master trace.\n",
"\n",
"\n",
"DESCRIPTION:\n",
"     A cross-correlation of all traces in memory with the master trace\n",
"     is  computed.   If  the master (first) trace is called x, and the\n",
"     other trace is called y, the cross-correlation is defined as\n",
"       INT x(tau)y(t + tau) dtau\n",
"\n",
"     When the Number or Length options are  used,  the  original  time\n",
"        series are cut into segments of equal length. The correlations\n",
"        are  computed  and  then  stacked. The average of the stack is\n",
"        then output.\n",
"\n",
"        After the  correlation  operation,  the  files  are  named  as\n",
"        follow:  [STA1][CMP1]_[STA2][CMP2]. The EVLA and EVLO are that\n",
"        of STA1 and the STLA and STLO are those of STA2.\n",
"CAUTION\n",
"     Note that correlation is done in absolute time. If the  x(t)  and\n",
"     y(t)  have  vastly different reference times, the values of the B\n",
"     and E may not be correct because of the  problem  of  stuffing  a\n",
"     double into a float.\n",
"HEADER CHANGES:\n",
"     DEPMIN,  DEPMAX, DEPMEN, EVLA, EVLO, STLA, STLO, DIST, GCARC. The\n",
"     time markers O, B and E are set. The others are reset to  -12345.\n",
"     T9  is  set  to  the  offset  time  of  the maximum of the cross-\n",
"     correlation\n",
"DEFAULT:\n",
"     MASTER 1 NUMBER 1 LENGTH OFF\n",
"SEE ALSO:\n",
""
};

char *help_cut [] = {
"\n",
"\n",
"GSAC Command Reference Manual                                 CUT\n",
"\n",
"SUMMARY:\n",
"     Cut a trace as it is read.\n",
"\n",
"     CUT [ON|OFF] [ ref offset | GMT beg | CAL beg | VEL vref voffsetb\n",
"     ] [ ref offset | GMT end | CAL end | VEL vref voffsete ]\n",
"\n",
"INPUT:\n",
"     ON       : Permit cutting on read\n",
"     OFF      : Turn off cutting on read\n",
"     ref       :  A header reference value for the cut which is one of\n",
"        B|E|O|A|Tn where n=0,...,9\n",
"     offset   : Number of seconds relative  to  the  reference  value.\n",
"        refbeg  offset  refers to the start point refend offset refers\n",
"        to the  end  point\n",
"     CAL      : Calendar time in YEAR MONTH  DAY  HOUR  MINUTE  SECOND\n",
"        MILLISECOND\n",
"     GMT       :  GMT  time  in  YEAR  DAY_OF_YEAR  HOUR MINUTE SECOND\n",
"        MILLISECOND\n",
"     VEL      : If O (origin) and DIST are set, select a  time  window\n",
"        about the group velocity vref. Internally input is adjusted so\n",
"        that the tiem window exists\n",
"\n",
"DESCRIPTION:\n",
"     This routine cuts a trace on the next READ according to specified\n",
"     header  values.  This  is  useful for focusing on one part of the\n",
"     trace.\n",
"     The option for CAL or GMT times was introduced  11  JAN  2005  to\n",
"        permit selection of time windows from very long time segments.\n",
"        The following are equivalent:\n",
"     CUT GMT 2005 001 01 02 03 456 GMT 2005 032 06 05 04 321\n",
"     CUT GMT 2005 001 01 02 03 456 CAL 2005 02 01 06 05 04 321\n",
"     CUT CAL 2005 01 01 01 02 03 456 GMT 2005 032 06 05 04 321\n",
"     CUT CAL 2005 01 01 01 02 03 456 CAL 2005 02 01 06 05 04 321\n",
"     which  cuts from January 1, 2005 01:02:03.456 to February 1, 2006\n",
"        06:05:04.321\n",
"\n",
"        The  velocity  cut  was  introduced  to  look  at  a  set   of\n",
"        interstation Green's functions and also to focus on a surface-\n",
"        wave arrival for moment tensor inversion. Some examples are\n",
"     VEL 3.3 -30 VEL 3.3 70\n",
"     which  gives a window 100 seconds long starting 30 seconds before\n",
"        the arrival with a group velocity of 3.3 km/s\n",
"\n",
"\n",
"SAC COMPATIBILITY:\n",
"SEE ALSO\n",
"     CUTERR\n",
"Note\n",
"     The CUTERR FILLZ is done by default\n",
""
};

char *help_cuterr [] = {
"\n",
"\n",
"GSAC Command Reference Manual                              CUTERR\n",
"\n",
"SUMMARY:\n",
"\n",
"INPUT:\n",
"DESCRIPTION:\n",
"SAC COMPATIBILITY:\n",
"SEE ALSO\n",
""
};

char *help_dec[] = {
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                            DECIMATE\n",
"\n",
"SUMMARY:\n",
"     Decimate trace by an integer\n",
"\n",
"     DECimate  [n]\n",
"\n",
"INPUT:\n",
"     [n]      : decimation factor - an integer\n",
"\n",
"DESCRIPTION:\n",
"     This  routine  decimates a trace by outputting the first and then\n",
"     every n points.  The resultant time series changes length.\n",
"\n",
"     NOTE THE DECIMATION FACTOR IS NEVER REMEMBERED - THE  DEFAULT  IS\n",
"     ALWAYS 1\n",
"SAC COMPATIBILITY:\n",
"     Sac  limits  the  decimation  interval  to  2  <= n <= 7. This is\n",
"     because Sac permits an anti-aliasing filter  option  which  meant\n",
"     that those filter coefficients must be built into the program.\n",
"\n",
"     In  the  GSAC  implementation,  I  suggest  a zero phase low pass\n",
"     filter at a frequency 0.5 the Nyquist frequency,  or  0.25/DELTA,\n",
"     perhaps a\n",
"     lp c corner_frequency n 4 p 2\n",
"\n",
"EXAMPLES:\n",
"     dec  2\n",
"HEADER VALUES SET:\n",
"     NPTS, DELTA, B, E, DEPMIN, DEPMAX, DEPMEN\n",
"\n",
"DEFAULT\n",
"     decimate 1\n",
""
};

char *help_del [] = {
"\n",
"\n",
"GSAC Command Reference Manual                              DELETE\n",
"\n",
"SUMMARY:\n",
"     Delete a file in memory from any trace processing\n",
"\n",
"     DELETE trace_number\n",
"\n",
"INPUT:\n",
"\n",
"DESCRIPTION:\n",
"     This is useful if one finds a bad trace in a large input and does\n",
"     not  appear in any trace processing. It still stays in memory but\n",
"     will never be output.\n",
"\n",
"SEE ALSO\n",
"     UNDELETE\n",
""
};

char *help_dif[] = {
"\n",
"\n",
"GSAC Command Reference Manual                                 DIF\n",
"\n",
"SUMMARY:\n",
"     Differentiate  all SAC data files in  memory.\n",
"\n",
"     DIF\n",
"\n",
"SAC COMPATIBILITY:\n",
"     SAC  permits   a choice of TWO, THREE and FIVE point operators. A\n",
"     simple two-point rule is used here.\n",
"\n",
"SEE ALSO\n",
"     INT\n",
""
};

char *help_div[] = {
"\n",
"\n",
"GSAC Command Reference Manual                                 DIV\n",
"\n",
"SUMMARY:\n",
"     Divide  all SAC data files in  memory by a constant.\n",
"\n",
"     DIV [v],\n",
"\n",
"INPUT:\n",
"     [v]      : constant which all  files are divided\n",
"\n",
"SAC COMPATIBILITY:\n",
"     SAC  permits  an  extended syntax that permits applying different\n",
"     constants to respective files in memory. We have not  implemented\n",
"     this complexity.\n",
"DEFAULT:\n",
"     DIV 1\n",
"SEE ALSO\n",
"     ADD, SUB, MUL\n",
""
};

char *help_divf[] = {
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                                DIVF\n",
"\n",
"SUMMARY:\n",
"     Multiply Files in memory\n",
"\n",
"     DIVF  [Master n] [ Suffix suffix ] [Water water_level ] [ Default\n",
"     ]\n",
"\n",
"INPUT:\n",
"     Master         :  Trace uses as master trace. Default is 0, which\n",
"     is the first in memory.\n",
"     Suffix suffix : The traces are renamed and the original traces in\n",
"        memory are overwritten to be of the form\n",
"         [STA2][CMP2]_[STA1][CMP1].suffix. The default  value  of  the\n",
"        suffix  is  '.div'  ,BR Water water_level : By default this is\n",
"        0.0001 of  the  maximum  amplitude.  This  is  used  to  avoid\n",
"        dividing     by     zero.     Thus     instead     of     X/Y,\n",
"        X/MAX(water_level*ymax,Y) is computed.\n",
"\n",
"DESCRIPTION:\n",
"     This divides all traces in memory by the master trace. After  the\n",
"     division    operation    the   files   are   named   as   follow:\n",
"     [STA2][CMP2]_[STA1][CMP1].suffix Beware that nothing is  done  to\n",
"     the  original  header other than to reset the start and end times\n",
"     since the output  trace   is  only  for  the  common  overlapping\n",
"     absolute time window.\n",
"\n",
"     The  result  on  the master trace is to square it, and perhaps to\n",
"     change the begin and end of the trace.\n",
"\n",
"     This is designed to permit computation of spectral ratios,  using\n",
"     the amplitude spectra generated using writesp.\n",
"HEADER CHANGES\n",
"     DEPMAX, DEPMIN, DEPMEN, NPTS, B, O\n",
"\n",
"EXAMPLES:\n",
"DEFAULT:\n",
"     DIVF MASTER 0 Suffix .div\n",
"SEE ALSO\n",
"     ADDF, SUBF, MULF\n",
""
};

char *help_echo[] = {
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                                ECHO\n",
"\n",
"SUMMARY:\n",
"     Echo a line of text to the terminal\n",
"\n",
"     ECHO [message]\n",
"\n",
"INPUT:\n",
"     message  : text to be output to terminal.\n",
"\n",
"DESCRIPTION:\n",
"\n",
"EXAMPLES:\n",
"\n",
"SEE ALSO\n",
"     PAUSE\n",
""
};

char *help_env [] = {
"\n",
"\n",
"GSAC Command Reference Manual                            ENVELOPE\n",
"\n",
"SUMMARY:\n",
"     Get the envelope of  a trace.\n",
"\n",
"     ENVELOPE\n",
"\n",
"INPUT:\n",
"\n",
"DESCRIPTION:\n",
"     This  determines  the  envelope  by  first  computing the Hilbert\n",
"     transform, q(t), of the trace,  h(t),  and  then  performing  the\n",
"     operation sqrt[h(t)*h(t) + q(t)*q(t)].\n",
"\n",
"SEE ALSO\n",
"     ENVELOPE\n",
""
};

char *help_exp [] = {
"\n",
"\n",
"GSAC Command Reference Manual                                 EXP\n",
"\n",
"SUMMARY:\n",
"     Exponentiate trace.\n",
"\n",
"EXP\n",
"\n",
"INPUT:\n",
"\n",
"DESCRIPTION:\n",
"     This  exponentiates  a trace. However NOTHING will be done if the\n",
"     trace value is greater than 85 since  this  would  yield  a  real\n",
"     number > 1.0E+37.\n",
"\n",
"SEE ALSO\n",
"     SQRT, SQR, LOG, ABS\n",
""
};

char *help_exp10 [] = {
"\n",
"\n",
"GSAC Command Reference Manual                               EXP10\n",
"\n",
"SUMMARY:\n",
"     Raise trace to power of 10 .\n",
"\n",
"EXP10\n",
"\n",
"INPUT:\n",
"\n",
"DESCRIPTION:\n",
"     This  exponentiates  a trace raising it to a power of 10. However\n",
"     NOTHING will be done if the trace value is greater than 37  since\n",
"     this would yield a real number > 1.0E+37.\n",
"\n",
"SEE ALSO\n",
"     SQRT, SQR, LOG, ABS\n",
""
};

char *help_fft[] = {
"\n",
"\n",
"GSAC Command Reference Manual                                 FFT\n",
"\n",
"SUMMARY:\n",
"     Obtain the discrete Fourier transform of traces in memory\n",
"\n",
"     FFT  [Length 1|2|4|8] [Default]\n",
"INPUT\n",
"     Length  Nvalue  -  pad the time series with zeros to increase the\n",
"     FFT by a factor or 1, 2, 4 or 8. The purpose of this is to ensure\n",
"     greater frequency resolution.\n",
"\n",
"     Default - resent Length to 1\n",
"\n",
"        Note that the use must ensure there is no offset  between  the\n",
"        time  series  and  the  appended  zeros by some combination of\n",
"        RMEAN, RTR or TAPER. The default is Length = 1.\n",
"\n",
"        Note also that zeros are always added since the FFT requires a\n",
"        power of 2 length.\n",
"\n",
"\n",
"DESCRIPTION:\n",
"     This estimates the discrete Fourier transform of the traces in by\n",
"     using  a  version  of  Brenner's  original  FOUR1  routine.   The\n",
"     definition of the DFT is\n",
"                           N-1       j {2 pi n k/N}\n",
"           H( n DF ) = DT  SUM h(k) e\n",
"                           k=0\n",
"     where  DF  =  1/(N DT), DT = sampling interval, DELTA, and N is a\n",
"     power of 2. Note that this is an extension to the definition   of\n",
"     a DFT in that physical dimension are introduced\n",
"NOTE\n",
"     This  DFT  is  with respec to the first data point. this decision\n",
"     controls the phase.  The WRITESP has the option to set the  phase\n",
"     with respect the O (origin marker)\n",
"DEFAULT\n",
"     FFT L 1\n",
"\n",
"SEE ALSO\n",
"     PLOTSP, WRITESP, RMEAN, RTR, TAPER\n",
""
};

char *help_fileid[] = {
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                              FILEID\n",
"\n",
"SUMMARY:\n",
"     Controls the plot legend\n",
"\n",
"     FILEID   [ON|OFf]  [  TYpe  DEfault|Name|LIst  hdrlist]  LOcation\n",
"     [UR|UL|LR|LL|UC|LC]        CONcat         [ON|OFf]         Format\n",
"     [EQUals|COLons|NONames]\n",
"\n",
"INPUT:\n",
"     ON   :   Turn on file id option.  Does not change file id type or\n",
"     location.\n",
"     OFf  :  Turn off file id option.\n",
"     TYpe DEfault  :  Change to the default file label. This is KSTNM,\n",
"        KCMPNM\n",
"     TYpe Name  :  Use the name of the file as the file label.\n",
"     TYpe LIst hdrlist  :  Define a list of header fields  to  display\n",
"        in the fileid.\n",
"     The  header  fields permitted are the exact words KZDATE, KZTIME,\n",
"        KCMPNM, KSTNM, KEVNM, GCARC, DIST, AZ, BAZ, STLA, STLO,  STEL,\n",
"        EVLA,  EVLO,  EVDP,  USER1, USER2, USER3, USER4, USER5, USER6,\n",
"        USER7, USER8, USER9, which are Sac header values. In  addition\n",
"        the keyword FNAME can be used to output the file name together\n",
"        with  the  header  values.  However  no more that the first 29\n",
"        characters of FNAME are output.  Also the keyword  BNAME  will\n",
"        just output the filename after stripping off the complete path\n",
"        information.  The programs permits up to ten (10) such labels.\n",
"        However, because of  limited  space  the  appearance  will  be\n",
"        messy.\n",
"     CONCAT        :  When using the  LIst hdrlist  output the strings\n",
"        horizontally instead of vertically. This  is  useful  if  many\n",
"        traces  are plotted, especially in OVERLAY mode. The ON or OFf\n",
"        controls this feature.\n",
"     LOcation UR  :  Place file id in upper right hand corner.\n",
"     LOcation UL  :  Place file id in upper left hand corner.\n",
"     LOcation UC  :  Place file id in upper center.\n",
"     LOcation LC  :  Place file id in lower center.\n",
"     LOcation LR  :  Place file id in lower right hand corner.\n",
"     LOcation LL  :  Place file id in lower left hand corner.\n",
"     Format EQuals  :  Format consists of header field name, an equals\n",
"        sign, and the header field value.\n",
"     FOrmat COlon  :  Format consists of header field name,  a  colon,\n",
"        and the value.\n",
"     FOrmat  NOnames   :   Format  consists of header field value only\n",
"        with no label.\n",
"DESCRIPTION:\n",
"\n",
"DEFAULT\n",
"     The default mode is the station and component name.\n",
"     The NAME just lists the file name including directory information\n",
"     The LIST options gives up to ten items\n",
"\n",
"     FILEID ON TYPE DEFAULT LOCATION UR FORMAT NONAMES\n",
"\n",
"\n",
"SEE ALSO\n",
""
};

char *help_filter [] = {
"\n",
"\n",
"GSAC Command Reference Manual                              FILTER\n",
"\n",
"SUMMARY:\n",
"     Apply or remove an instrument response/filter from the data\n",
"\n",
"     FILTER   [FROM|TO]   [APPLY|REMOVE]  [POLEZERO  pzfile]  [FAPFILE\n",
"     fapfile] [EVAL afile pfile]\n",
"              [FREQLIMITS f1 f2 f3 f4] [NOFREQLIMITS]\n",
"\n",
"INPUT:\n",
"     APPLY or TO      : The wave form is passed through the filter\n",
"     REMOVE or FROM   : The instrument filter is deconvolved from  the\n",
"        trace\n",
"     POLEZERO pzfile  : Use the SAC Pole-zero format\n",
"     EVAL  afile  pfile  :  Use  the output of the IRIS evalresp which\n",
"        gives  two  files,  one  of  gain(frequency)  and  the   other\n",
"        phase(freq)\n",
"     FAPFILE fapfile  : Use the Frequency/amplitude/phase file\n",
"     FREQLIMITS  f1  f2  f3  f4i : Apply a cubic taper to the response\n",
"        such the response is 0 for f < f1 and for f > f4, the response\n",
"        is 1 for f > f2 and for f < f3, and tapers cubically from 0 to\n",
"        1 for f1 < f < f2 and f4 > f > f3.  Note the only way to  turn\n",
"        this  off  is to reset the limits as in FREQLIMITS -2 -1 1.0e5\n",
"        1.0e6 FREQLIMITS is only used in the FROM  process.   This  is\n",
"        essential for a clean deconvolution\n",
"DESCRIPTION:\n",
"\n",
"SAC COMPATIBILITY:\n",
"     This  is  similar in concept to the the SAC TRANSFER, which where\n",
"     the pazfile is the displacement sensitivity  of  the  instrument.\n",
"     This  command  is suitable to the forward transform, but must not\n",
"     be  used   for   a   deconvolution   that   involves   a   second\n",
"     transformation, e.g., do not try\n",
"            FILTER FROM POLEZERO pzfile FREQLIMITS f1 f2 f3 f4\n",
"            FILTER  TO  VEL  because  this  actually  creates two time\n",
"     series and used the Fast  Fourier  transform  to  accomplish  the\n",
"     filtering.  Taking  a  derivative  of  the second series to yield\n",
"     velocity, may introduce a glitch at the last point This  artifact\n",
"     could  be  eliminated  if a frequency domain bilinear Z-transform\n",
"     differentiator were implemented.  Instead use the syntax\n",
"     TRANSFER FROM POLEZERO SUBTYPE  pzfile FREQLIMITS f1 f2 f3 f4  TO\n",
"        VEL\n",
"     NOFREQLIMITS is not in SAC\n",
"\n",
"HEADER VALUES SET\n",
"     USER1 = permin, USER2=permax, where\n",
"      permin=MAX[1.0/filt_f3,old permin] and\n",
"      permax=MIN[1./filt_f2,old permax]. This feature is used\n",
"      by sacmft96 and sacpom96\n",
"SEE ALSO\n",
"     TRANSFER\n",
""
};

char *help_fg [] = {
"\n",
"\n",
"GSAC Command Reference Manual                             FUNCGEN\n",
"\n",
"SUMMARY:\n",
"     Generate a synthetic time series for testing.\n",
"\n",
"     FuncGen  [Impulse | Triangle | Box  | Gaussian]  Delta delta NPts\n",
"     npts [ Length  length ] [Comp ncomb delay ] [ Alpha alpha ] [NOrm\n",
"     ON | OFF ] [SIN2 duration] [SIN4 duration] [PAR2 duration]\n",
"INPUT:\n",
"     Impulse  : Generate a  time  series  with  a  single  point  with\n",
"     amplitude  equal  to  1.0/delta,  where  delta  is  the  sampling\n",
"     interval in seconds. The impulse is centered at npts/2, and the B\n",
"     header value is set as - (npts/2)*delta. The default output  file\n",
"     is  called  impulse.sac  This  will have a unit Fourier amplitude\n",
"     spectrum.\n",
"     Triangle  :  Generate  a  time  series  with  three  points  with\n",
"        amplitudes equal to ( 0.25/deta, 0.50/delta, 0.25/delta) where\n",
"        delta  is  the  sampling  interval in seconds. The triangle is\n",
"        centered at npts/2, and  the  B  header  value  is  set  as  -\n",
"        (npts/2)*delta. The default output file is called triangle.sac\n",
"        This will have a unit spectral amplitude at zero frequency and\n",
"        a spectral zero at the Nyquist frequency, 0.5/delta.\n",
"     Box      :  Create  a  boxcar  with duration of 'length' seconds,\n",
"        starting at  center  of  the  trace.  The  minimum  length  is\n",
"        internally set to 10*delta!\n",
"     Gaussian  :  Create a Gaussian pulse with parameter alpha. In the\n",
"        frequency domain the spectrum of the pulse is exp [ - ( pi f /\n",
"        alpha  )  ^2  ]  and in the time domain this is ( alpha / sqrt\n",
"        (pi)) exp ( - alpha^2 t^2 ). Note this is formed in  the  time\n",
"        domain  and  is  truncated when for the exponential  less than\n",
"        0.01.  Thus  the  duration  of  the  pulse  is   approximately\n",
"        4.28/alpha seconds.\n",
"     Alpha   : Gaussian shape parameter used only with Gaussian pulse\n",
"     Delta   : Sample interval in seconds\n",
"     NPts    : Number of points in the time series\n",
"     Comb    : repeat the chosen pulse 'ncomb' times with a separation\n",
"        of  'delay'  seconds.  The total area of this function is 1.0.\n",
"        This is designed to create complicated pulses.\n",
"     SIN2 tau : The positive pulse is sin^2( pi t / tau) for 0 <= t <=\n",
"        tau\n",
"     SIN4 tau : The positive pulse is sin^2( pi t / tau) for 0 <= t <=\n",
"        tau\n",
"     PAR2 tau : This is the double integral of the Day, Rimer,  Cherry\n",
"        (1983)  spall  force time function.  This function arises from\n",
"        factoring mg out from the expression  and  integrating  twice.\n",
"        The  result,  less  the mg factor, is the source time function\n",
"        for the equivalent opening horizontal  of  Day  and  McLauglin\n",
"        (1991).\n",
"\n",
"        [ t H(t) + (t-tau) H(t-tau) - t^2 H(t) - (t-tau)^2 H(t-tau) ]/2\n",
"\n",
"        where tau is the duration and H(x) is the unit step function..\n",
"     NOrm ON|OFF : Default OFF.\n",
"        If  ON, then the SIN2, SIN4 and PAR2 pulses have unit area and\n",
"        the peak amplitudes are (2/tau), (8/3 tau) and (3/2 tau).\n",
"\n",
"        If OFF, then  the peak amplitude of these pulses  are  1,   1,\n",
"        and  (1/8)  duration^2,  respectively. The  spectral levels at\n",
"        zero frequency are  (tau/2),  (3  tau/8)  and  (tau^3  /  12),\n",
"        respectively.\n",
"NOTE:\n",
"     The  A header value is set at the beginning of the SIN2, SIN4 and\n",
"     PAR2 pulses for convenience in convolution (help convolve)\n",
"DESCRIPTION:\n",
"     This generates a synthetic  time  series.  At  present  only  the\n",
"     impulse and triangle pulses are supported. The internal file name\n",
"     is either 'impulse.sac' or 'triangle.sac'.\n",
"REFERENCES:\n",
"     Day,  S  M.  and N. Rimer and J. J. Cherry (1983).  Surface waves\n",
"     from underground explosions with spall: Analysis of  elastic  and\n",
"     nonlinear source models, Bull. Seis. soc. Am., 73, pp 247-264.\n",
"\n",
"     Day,   S.   M.   and   K.  L.  McLaughlin  (1991).Seismic  source\n",
"     representations for spall, Bull. Seism. Soc., 81, pp 191-201.\n",
"\n",
"SAC COMPATIBILITY:\n",
"     SAC creates an impulse  to  have  unit  amplitude  int  the  time\n",
"     domain,  which means that the spectral amplitude will be 'delta'.\n",
"     GSAC creates an impulse with  unit  spectral  amplitude  at  zero\n",
"     frequency.  This is done to permit an easy view of the instrument\n",
"     response:\n",
"               funcgen impulse delta  0.05 npts 4096\n",
"               transfer from none to polezero subtype resp.paz\n",
"               fft\n",
"               psp am\n",
"DEFAULT:\n",
"     FUNCGEN IMPULSE DELTA 1.0 NPTS 1024 ALPHA 1.0\n",
"\n",
"SEE ALSO\n",
""
};

char *help_grid[] = {
"\n",
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                                GRID\n",
"\n",
"SUMMARY:\n",
"     Control plot grid for x- and y-axes\n",
"\n",
"     GRID  [ ON | OFF ] [ Solid | Dotted ] [ Color int_value ] [ Minor\n",
"     ON | OFF ]\n",
"\n",
"INPUT:\n",
"     ON         : turn grid on\n",
"   OFF        : turn grid off\n",
"   Solid      : Use solid line\n",
"   Dashed     : Use dotted line\n",
"   Minor      : connect minor tics too if ON\n",
"   Color  int_value  : Define the color for the grid. The figure frame\n",
"        will continue to be in black. Be careful to select a color not\n",
"        used for the trace.\n",
"DESCRIPTION:\n",
"     This annotates the plots with a grid. Note that the Dotted option\n",
"     is takes more time to plot.\n",
"\n",
"EXAMPLES:\n",
"DEFAULT\n",
"               GRID OFF DOTTED COLOR 1030 MINOR OFF\n",
"   [Note COLOR 1 is black, 2 red, 3 green, 4 blue, 1030 pale yellow ]\n",
"\n",
"SEE ALSO\n",
"     XGRID, YGRID, COLOR\n",
""
};

char *help_hp[] = {
"\n",
"\n",
"GSAC Command Reference Manual                            HIGHPASS\n",
"\n",
"SUMMARY:\n",
"     HighPass filter traces\n",
"\n",
"     HighPass [options]\n",
"\n",
"     where options is one or more of the following:\n",
"\n",
"     [Butter  | BEssel | C1 ] [ Corner fc ] [ Npoles npoles ] [ Passes\n",
"     npass] [ Tranbw tranbw ] [ Atten atten ]\n",
"\n",
"INPUT:\n",
"     Butter   : Butterworth filter\n",
"     BEssel   : Bessel filter\n",
"     C1       : Chebyshev Type I filter\n",
"     Corner   : Corner frequency (R) range 0 - Nyquist\n",
"     Npoles   : Number of poles  (I) range 1 - 10\n",
"     Passes   : Number of passes (I) range 1 - 2\n",
"     Tranbw   : Chebyshev transition bandwidth fraction (0.3 default)\n",
"     Atten    : Chebyshev stop band attenuation (30 default)\n",
"\n",
"DESCRIPTION:\n",
"     Highpass filter using a BI-LINEAR Z-transformation implementation\n",
"     of a highpass filter. A bi-linear method is chosen since this  is\n",
"     easily  implemented  algebraically.  Passes  =  1  gives a causal\n",
"     filter while Passes = 2 gives a  zero-phase  filter  with  a  6db\n",
"     point at the corner frequency.\n",
"\n",
"     The lowpass filter design of the Chebyshev Type 1 filter is based\n",
"     on  the  information  in   Hamming  (1997)  equation (13.5.4) and\n",
"     Figure 13.6.1,  This  filter  attempts  to  approximate  a  sharp\n",
"     lowpass filter. In reality a transition band is defined by Fp and\n",
"     Fs,  where  Fp  is  the  lowpass  corner  frequency and Fs is the\n",
"     stopband, where Fs = (1 + tranbw)*Fp.  The amplitude level of the\n",
"     stop band (f > Fs) is 1/atten.  Actual implementation requires  a\n",
"     parameter  epsilon,  eps, which defines the lowpass ripple, which\n",
"     varies between 1 and 1/sqrt(1 + eps*eps).\n",
"          Hamming, Richard W. (1997). Digital Filters  (3rd  edition),\n",
"          Dover Publications, 296 pp, ISBN 048665088X\n",
"     Given npoles and eps, the poles and zeros are given by\n",
"          http://www.answers.com/topic/chebyshev-filter\n",
"     The correct normalization amplitude together with poles and zeros\n",
"     is given in\n",
"          Digital  Filter  Designers  Handbook with C++ algorithms, C.\n",
"          Britton Rorabaugh 2nd Edition, McGraw Hill, New York, 479 pp\n",
"          1997  Chapter 5\n",
"\n",
"HEADER VALUES SET\n",
"               USER1 = permin, USER2=permax, where  permin=1.0/(2*dt),\n",
"     andpermax= 1.0/(filt_fl) for use by sacmft96 and sacpom96\n",
"SEE ALSO\n",
"               LOWPASS, BANDPASS, BANDREJECT\n",
""
};

char *help_hilb [] = {
"\n",
"\n",
"GSAC Command Reference Manual                             HILBERT\n",
"\n",
"SUMMARY:\n",
"     Obtain the Hilbert transform of a trace\n",
"\n",
"     HILBERT\n",
"\n",
"DESCRIPTION:\n",
"     The  Hilbert  transform  of  each  trace  is  obtained.  This  is\n",
"     implemented using Discrete Fourier Transforms. Since the  Hilbert\n",
"     transform  of  an impulse is infinitely long, there may be a wrap\n",
"     around problem, which can be alleviated by using  a  longer  tome\n",
"     series.  By  definition the Hilbert transform does not change the\n",
"     amplitude spectrum but does change the spectrum by pi/2  radians.\n",
"     A  double invocation of Hilbert will yield an inverted version of\n",
"     the original trace.\n",
"SEE ALSO\n",
""
};

char *help_hist[] = {
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                             HISTORY\n",
"\n",
"SUMMARY:\n",
"     Display readline command history\n",
"\n",
"     HISTORY [Default | List n ]\n",
"\n",
"INPUT:\n",
"     List n   : List the last n commands\n",
"     Default  : List all commands since GSAC started.\n",
"\n",
"DESCRIPTION:\n",
"     When  compiled  with  the  GNU readline library, a history of the\n",
"     commands entered is saved. One can use a combination of the arrow\n",
"     keys and the users editor commands to  move  around  the  current\n",
"     command  line  and previous command lines.  When the ENTER key is\n",
"     hit, the command line will be interpreted by GSAC.\n",
"\n",
"     Often it may be useful to review the history, and  then  cut  and\n",
"     paste to repeat previous commands.\n",
"\n",
"     Unlike  the  history  mechanism  of  the  CSH or BASH shells, one\n",
"     cannot use the !n  sequence to edit previous lines.\n",
"\n",
"DEFAULT:\n",
"     HISTORY DEFAULT\n",
"SEE ALSO\n",
""
};

char *help_hold[] = {
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                                HOLD\n",
"\n",
"SUMMARY:\n",
"     Permit plot overlay in current frame\n",
"\n",
"     HOLD [ON | OFF]\n",
"\n",
"INPUT:\n",
"     ON       : Set the HOLD for the next plot\n",
"     OFF      : Unset the HOLD option. The next instance of PRS PSP or\n",
"        P1 will start on a new page.\n",
"\n",
"DESCRIPTION:\n",
"     To  permit  an  overlay  of  different graphics on a current plot\n",
"     frame, one must not perform an erase.  HOLD  is  similar  to  the\n",
"     MATLAB HOLD command which has the same purpose.\n",
"\n",
"EXAMPLES:\n",
"\n",
"SEE ALSO\n",
"     PCTL, P1, PSP, PRS\n",
""
};

char *help_int[] = {
"\n",
"\n",
"GSAC Command Reference Manual                                 INT\n",
"\n",
"SUMMARY:\n",
"     Integrate  all SAC data files in  memory.\n",
"\n",
"     INT\n",
"\n",
"\n",
"SAC COMPATIBILITY:\n",
"     SAC  permits   a  choice  of  TRAPEZOIDAL or RECTANGULAR rules. A\n",
"     simple one-point running summation is used. The  first  point  of\n",
"     the  output is set to zero to avoid a linear trend in the output.\n",
"     DEFAULT\n",
"\n",
"\n",
"SEE ALSO\n",
"     DIF\n",
""
};

char *help_in [] = {
"\n",
"\n",
"GSAC Command Reference Manual                         INTERPOLATE\n",
"\n",
"SUMMARY:\n",
"     Resample the current traces in memory\n",
"\n",
"     INTERPOLATE [Delta new_delta}\n",
"\n",
"INPUT:\n",
"     Delta  new_delta  :  Define  the new sample interval. This may be\n",
"     greater or less than the current DELTA of the trace.\n",
"\n",
"DESCRIPTION:\n",
"     When comparing observed and synthetics quantitatively, the traces\n",
"     sample intervals  must  be  identical.  This  routine  permits  a\n",
"     resampling at an arbitrary new DELTA. The start time of the trace\n",
"     is maintained, but the number of points and end time are changed.\n",
"     When  the  new_delta  > the original DELTA, it is best to lowpass\n",
"     filter the trace before interpolating\n",
"SEE ALSO\n",
""
};

char *help_linlin [] = {
"\n",
"\n",
"GSAC Command Reference Manual                              LINLIN\n",
"\n",
"SUMMARY:\n",
"     lin-lin plot for plot, plotpk\n",
"\n",
"LINLIN\n",
"\n",
"INPUT:\n",
"\n",
"DESCRIPTION:\n",
"\n",
"DEFAULT:\n",
"     Linear x-axis and linear y-axis\n",
"\n",
"SEE ALSO\n",
"     XLIN, YLIN, XLOG, YLOG, LOGLIN, LOGLIN, LOGLOG\n",
""
};

char *help_linlog [] = {
"\n",
"\n",
"GSAC Command Reference Manual                              LINLOG\n",
"\n",
"SUMMARY:\n",
"     lin-log plot for plot, plotpk\n",
"\n",
"LINLOG\n",
"\n",
"INPUT:\n",
"\n",
"DESCRIPTION:\n",
"\n",
"DEFAULT:\n",
"     Linear x-axis and linear y-axis\n",
"\n",
"SEE ALSO\n",
"     XLIN, YLIN, XLOG, YLOG, LINLIN, LOGLIN, LOGLOG\n",
""
};

char *help_lh[] = {
"\n",
"\n",
"GSAC Command Reference Manual                          LISTHEADER\n",
"\n",
"SUMMARY:\n",
"     List trace header values\n",
"\n",
"     ListHeader  [options]  where  options  is  one  or  more  of  the\n",
"     following:\n",
"\n",
"     [Default ] [ list]\n",
"\n",
"INPUT:\n",
"     Default  : Output all defined header fields\n",
"     list     : a listing of header fields to output\n",
"     Columns 1 : 1 column output\n",
"     Columns 2 : 2 column output\n",
"\n",
"DESCRIPTION:\n",
"     Output header values. See the documentation for  ChangeHeader  to\n",
"     learn  the  header  values.  However  one cannot use OGMT or OCAL\n",
"     since these are used  only  in  ChangeHeader.   No  unset  header\n",
"     value, indicated by the -12345 sequence, will be displayed.\n",
"\n",
"     EXAMPLES: List distance, azimuth and P and S picks\n",
"          LH DIST AZ A T0\n",
"SAC COMPATIBILITY\n",
"     SAC  defaults  to a single column listing and has a built in more\n",
"     command.\n",
"\n",
"SEE ALSO\n",
""
};

char *help_log [] = {
"\n",
"\n",
"GSAC Command Reference Manual                                 LOG\n",
"\n",
"SUMMARY:\n",
"     Take natural logarithm of trace\n",
"\n",
"LOG\n",
"\n",
"INPUT:\n",
"\n",
"DESCRIPTION:\n",
"     This  takes  the  natural  logarithm of a trace.  However NOTHING\n",
"     will be done if the trace value is negative or zero.\n",
"\n",
"SEE ALSO\n",
"     SQRT, SQR, EXP, ABS\n",
""
};

char *help_log10 [] = {
"\n",
"\n",
"GSAC Command Reference Manual                               LOG10\n",
"\n",
"SUMMARY:\n",
"     Take base 10 log of trace\n",
"\n",
"LOG10\n",
"\n",
"INPUT:\n",
"\n",
"DESCRIPTION:\n",
"     This  takes  the  base  10 logarithm of a trace.  However NOTHING\n",
"     will be done if the trace value is negative or zero.\n",
"\n",
"SEE ALSO\n",
"     SQRT, SQR, EXP, ABS\n",
""
};

char *help_lp[] = {
"\n",
"\n",
"GSAC Command Reference Manual                             LOWPASS\n",
"\n",
"SUMMARY:\n",
"     LowPass filter traces\n",
"\n",
"     LowPass [options]\n",
"\n",
"     where options is one or more of the following: [Butter | BEssel |\n",
"     C1  ]  [  Corner  fc ] [ Npoles npoles ] [ Passes npass] [ Tranbw\n",
"     tranbw ] [ Atten atten ]\n",
"INPUT:\n",
"     Butter   : Butterworth filter\n",
"     BEssel   : BEssel filter\n",
"     C1       : Chebyshev Type I filter\n",
"     Corner   : Corner frequency (R) range 0 - Nyquist\n",
"     Npoles   : Number of poles  (I) range 1 - 10\n",
"     Passes   : Number of passes (I) range 1 - 2\n",
"     Tranbw   : Chebyshev transition bandwidth fraction (0.3 default)\n",
"     Atten    : Chebyshev stop band attenuation (30 default)\n",
"DESCRIPTION:\n",
"     Lowpass filter using a BI-LINEAR Z-transformation  implementation\n",
"     of  a  lowpass filter. A bi-linear method is chosen since this is\n",
"     easily implemented algebraically.  Passes  =  1  gives  a  causal\n",
"     filter  while  Passes  =  2  gives a zero-phase filter with a 6db\n",
"     point at the corner frequency.\n",
"\n",
"     The lowpass filter design of the Chebyshev Type 1 filter is based\n",
"     on the information  in   Hamming  (1997)  equation  (13.5.4)  and\n",
"     Figure  13.6.1,  This  filter  attempts  to  approximate  a sharp\n",
"     lowpass filter. In reality a transition band is defined by Fp and\n",
"     Fs, where Fp is the  lowpass  corner  frequency  and  Fs  is  the\n",
"     stopband, where Fs = (1 + tranbw)*Fp.  The amplitude level of the\n",
"     stop  band (f > Fs) is 1/atten.  Actual implementation requires a\n",
"     parameter epsilon, eps, which defines the lowpass  ripple,  which\n",
"     varies between 1 and 1/sqrt(1 + eps*eps).\n",
"          Hamming,  Richard  W. (1997). Digital Filters (3rd edition),\n",
"          Dover Publications, 296 pp, ISBN 048665088X\n",
"     Given npoles and eps, the poles and zeros are given by\n",
"          http://www.answers.com/topic/chebyshev-filter\n",
"     The correct normalization amplitude together with poles and zeros\n",
"     is given in\n",
"          Digital Filter Designers Handbook with  C++  algorithms,  C.\n",
"          Britton Rorabaugh 2nd Edition, McGraw Hill, New York, 479 pp\n",
"          1997  Chapter 5\n",
"HEADER VALUES SET:\n",
"     USER1  =  permin,  USER2=permax,  where  permin=1.0/filt_fh,  and\n",
"     permax= 0.01/(npts * dt) for use by sacmft96 and sacpom96\n",
"SEE ALSO:\n",
"     HIGHPASS, BANDPASS, BANDREJECT\n",
""
};

char *help_map[] = {
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                                 MAP\n",
"\n",
"SUMMARY:\n",
"     Produce GMT map\n",
"\n",
"     MAP  [options]\n",
"\n",
"     where options may include\n",
"\n",
"     [ North maxlat South minlat East maxlon West minlon ] [Topography\n",
"     ON | OFF] [ STation ON | OFF ] [ EPicenter ON | OFF ] [ Global ON\n",
"     | OFF ] [Raypath ON | OFF ] [ KStnm ON | OFF ] [Default]\n",
"\n",
"INPUT:\n",
"     North maxlat : maximum latitude\n",
"     South minlat : minimum latitude\n",
"     East  maxlon : maximum longitude\n",
"     West  minlon : minimum longitude\n",
"     STation      : Do or do not plot station locations\n",
"     EPicenter    : Do or do not plot epicenter locations\n",
"     Global        :  If  ON,  use  a  global  linear  projection from\n",
"        LATLON=-157/203/-80/80\n",
"     Raypath      : IF ON draw great circle path between epicenter and\n",
"        station\n",
"     KStnm        : IF ON draw station names\n",
"     Default      : returns to default parameters\n",
"     Topography   : if ON plots  from  global  topography  data  base,\n",
"        otherwise just coastline is plotted.\n",
"\n",
"DESCRIPTION:\n",
"     This routine examines the sac headers and plots station locations\n",
"     as a filled circles and the event locations as a star.\n",
"\n",
"     By  default  the SAC file headers are used to define the latitude\n",
"     and longitude limits.\n",
"\n",
"     If the latitude and longitude limits are not specified, the  plot\n",
"     is based on the event and station latitude and longitudes.\n",
"\n",
"     Unless  the  GLOBAL  is ON, a Mercator projection is used and the\n",
"     map LATLON variable in script never includes the poles.\n",
"\n",
"     The output of this routine is a shell script of GMT commands.  To\n",
"     create  the  map.eps,  you must enter the command: sh map.sh. The\n",
"     map.sh is annotated, so that you can easily  change  projections,\n",
"     symbol  sizes  and  colors,  raster  databases  with  very little\n",
"     editing and some knowledge of GMT. The shell script also includes\n",
"     a topographic resampling so permit lass grainy  plots  for  small\n",
"     regions as well as a crude image for global maps. The size of the\n",
"     image if kept small and should look good when converted to a PNG,\n",
"     GIF or JPG file.\n",
"\n",
"     The  encapsulated  PostScript file is called map.eps. This can be\n",
"     included in groff, LaTeX documents, or converted to PNG, GIF, JPG\n",
"     etc using ImageMagick display or convert for  including  in  Word\n",
"     documents or PowerPoint presentations.\n",
"EXAMPLES:\n",
"\n",
"DEFAULT:\n",
"     map   topography  off  station on epicenter on global off raypath\n",
"     off kstnm off\n",
"\n",
"SEE ALSO\n",
""
};

char *help_map5[] = {
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                                MAP5\n",
"\n",
"SUMMARY:\n",
"     Produce GMT 5 map\n",
"\n",
"     MAP5  [options]\n",
"\n",
"     where options may include\n",
"\n",
"     [ North maxlat South minlat East maxlon West minlon ] [Topography\n",
"     ON | OFF] [ STation ON | OFF ] [ EPicenter ON | OFF ] [ Global ON\n",
"     | OFF ] [Raypath ON | OFF ] [ KStnm ON | OFF ] [Default]\n",
"\n",
"INPUT:\n",
"     North maxlat : maximum latitude\n",
"     South minlat : minimum latitude\n",
"     East  maxlon : maximum longitude\n",
"     West  minlon : minimum longitude\n",
"     STation      : Do or do not plot station locations\n",
"     EPicenter    : Do or do not plot epicenter locations\n",
"     Global        :  If  ON,  use  a  global  linear  projection from\n",
"        LATLON=-157/203/-80/80\n",
"     Raypath      : IF ON draw great circle path between epicenter and\n",
"        station\n",
"     KStnm        : IF ON draw station names\n",
"     Default      : returns to default parameters\n",
"     Topography   : if ON plots  from  global  topography  data  base,\n",
"        otherwise just coastline is plotted.\n",
"\n",
"DESCRIPTION:\n",
"     This routine examines the sac headers and plots station locations\n",
"     as a filled circle and the event locations as a star.\n",
"\n",
"     By  default  the SAC file headers are used to define the latitude\n",
"     and longitude limits.\n",
"\n",
"     If the latitude and longitude limits are not specified, the  plot\n",
"     is based on the event and station latitude and longitudes.\n",
"\n",
"     Unless  the  GLOBAL  is ON, a Mercator projection is used and the\n",
"     map LATLON variable in script never includes the poles.\n",
"\n",
"     The output of this routine is a shell script of GMT commands.  To\n",
"     create  the map5.eps, you must enter the command: sh map5.sh. The\n",
"     map.sh is annotated, so that you can easily  change  projections,\n",
"     symbol  sizes  and  colors,  raster  databases  with  very little\n",
"     editing and some knowledge of GMT. The shell script also includes\n",
"     a topographic resampling so permit leas grainy  plots  for  small\n",
"     regions as well as a crude image for global maps. The size of the\n",
"     image if kept small and should look good when converted to a PNG,\n",
"     GIF or JPG file.\n",
"\n",
"     The  encapsulated PostScript file is called map5.eps. This can be\n",
"     included in groff, LaTeX documents, or converted to PNG, GIF, JPG\n",
"     etc using ImageMagick display or convert for  including  in  Word\n",
"     documents or PowerPoint presentations.  you may have to hand edit\n",
"     the   BoundingBox  in  the  eps  or  change  the  PS_SCALE_X  and\n",
"     PS_SCALE_Y in the map5.sh\n",
"EXAMPLES:\n",
"\n",
"DEFAULT:\n",
"     map  topography off station on epicenter on  global  off  raypath\n",
"     off kstnm off\n",
"\n",
"SEE ALSO\n",
""
};

char *help_markt[] = {
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                           MARKTIMES\n",
"\n",
"SUMMARY:\n",
"     Marks velocity times in plot\n",
"\n",
"     MARKTIMES  [DEFault]  [Distance Header|dist] [Origin   Header|GMT\n",
"     time | CAL time] [Velocities v ... ] [ON|OFF]\n",
"\n",
"INPUT:\n",
"     DEFault         : reset to default values\n",
"     Distance Header : Use the distance in the trace header if set\n",
"     Distance dist   : Use dist  as the  distance\n",
"     Origin Header   : Use the origin time in the trace headers if set\n",
"     Origin GMT time : Use time of the form   YEAR  JDAY  HOUR  MINUTE\n",
"        SECOND MILLISECOND\n",
"     Origin  CAL  time  :  Use  time  of the form  YEAR MONTH DAY HOUR\n",
"        MINUTE SECOND MILLISECOND\n",
"     Velocities v ... : Set of  velocities (km/s) to be used. No  more\n",
"        than 10 are permitted\n",
"     ON               :  Mark  the  times.  This  is automatically the\n",
"        condition when called unless turned off explicitly by the  OFF\n",
"        command.\n",
"     OFF             : Turn off marking\n",
"\n",
"DESCRIPTION:\n",
"     This  routine  marks  the velocity arrival times as a function of\n",
"     the origin time, distance and velocity set.  These are  indicated\n",
"     by BLUE colored tics with the command plot. The arrival times are\n",
"     determined from the simple equation\n",
"     arrival_time = origin_time + distance/velocity\n",
"SAC COMPATIBILITY:\n",
"     Nothing  is  set  in  the  header.  The  purpose  is  to indicate\n",
"     approximate arrival times for phase identification.  The  default\n",
"     values also include 1, 7 and 8 km/sec.\n",
"\n",
"\n",
"\n",
"EXAMPLES:\n",
"DEFAULT\n",
"     MARKTIMES  VELOCITIES  1.  2.  3.  4. 5. 6. 7. 8. DISTANCE HEADER\n",
"     ORIGIN HEADER\n",
"\n",
"\n",
"SEE ALSO\n",
"     PLOT\n",
""
};

char *help_merge[] = {
"\n",
"\n",
"GSAC Command Reference Manual                               MERGE\n",
"\n",
"Merge all files in memory to form a single trace.\n",
"\n",
"MERGE [ GAP gap_value ]\n",
"\n",
"INPUT:\n",
"     GAP  gap_value     :   Insert gap_value when filling in gaps. The\n",
"     default is to use a value of 0.0\n",
"\n",
"DESCRIPTION\n",
"     Data requests from the IRIS DMC often yield segmented traces when\n",
"     the SEED volume is read using rdseed to create  SAC  files.  This\n",
"     segmentation  may  reflect  actual  data  gaps, or just different\n",
"     submissions to the database.  The merge command will combine  all\n",
"     files   and   provide  diagnostic  information  on  the  absolute\n",
"     time/date of the beginning and end of each trace,  whether  there\n",
"     are  data gaps, and whether there are data inconsistencies in the\n",
"     individual amplitude values.\n",
"\n",
"SAC COMPATIBILITY:\n",
"     sac2000 does not permit changing the default fill of the gap.\n",
"DEFAULT\n",
"\n",
"SEE ALSO\n",
""
};

char *help_mt[] = {
"\n",
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                        MOMENTTENSOR\n",
"\n",
"SUMMARY:\n",
"     SUMMARY: Generate 3 component seismogram for moment tensor\n",
"\n",
"     MomentTensor  TO  [ZRT|ZNE|UZ|UR|UT|UN|UE|Z|R|T|N|E]  MW mw Az az\n",
"     [Baz baz] [STK stk DIP dip RAKE rake | ISO | FN fn Fe fe FD fd  |\n",
"     MXX mxx MYY myy MZZ mzz MXY mxy MXZ mxz MYZ myz ] FILE fileproto\n",
"\n",
"INPUT:\n",
"     ZRT            : generate ZRT components named T.Z T.R T.T\n",
"     ZNE            : generate  ZNE  components  named  T.Z  T.N   T.E\n",
"                      (requires back azimuth and ALL Green functions)\n",
"     UZ or Z        : generate Z component named T.Z\n",
"     UR or R        : generate R component named T.R\n",
"     UT or T        : generate T component named T.T\n",
"     UN or N        : generate  N  component  named T.N (requires back\n",
"        azimuth baz)\n",
"     UE  or  E         :  generate E  component  named  T.E  (requires\n",
"        back azimuth baz)\n",
"     MW  mw          :  Moment   magnitude   (default  2.60  (for  log\n",
"        Mo=20)).This  is  converted to Moment using Mw = 2/3(log Mo  -\n",
"        16.1) Mo  in  dyne-cm.  This  applies  to  double  couple  and\n",
"        isotropic sources.\n",
"     MXX mxx        : moment tensor element in units of dyne-cm, e.g.,\n",
"        MXX 1.0e+20\n",
"     MYY myy\n",
"     MZZ mzz\n",
"     MXY mxy\n",
"     MXZ mxz\n",
"     MYZ myz\n",
"     Az az          : source to receiver azimuth. (default 0)\n",
"     Baz   baz       : back  azimuth  (e.g.,  from receiver to source)\n",
"        (default mod(az+180,360). Note for teleseisms use the true baz\n",
"     ISO            : point source isotropic source (explosion)\n",
"     STK stk        : strike of double couple model\n",
"     DIP dip        : dip of double couple model\n",
"     RAKE rake      : rake off double couple model\n",
"     FE  fe          : point force directed east in units of  dynes\n",
"     FD  fd          : point force directed down in units of  dynes\n",
"     FN  fn          : point force directed north in units of  dynes\n",
"     FILE fileproto : full path of Green's function prototype\n",
"DESCRIPTION:\n",
"     This program accesses the Green s functions and generates a three\n",
"     component ground velocity  seismogram  in  units  off  m/s.   The\n",
"     command         used         the         fileproto,         e.g.,\n",
"     /home/rbh/PROGRAMS.310t/GREEN/nnCIA.REG/0005/011500005  and  adds\n",
"     the  suffix  .ZDD  etc  to  find  the Greens functions, which are\n",
"     combined to make a  three  component  seismogram  for  the  given\n",
"     mechanism and moment\n",
"\n",
"     Note that in the future the use of TO Z etc may  be  removed  and\n",
"     only TO UZ will be permitted.\n",
"Defaults\n",
"     The  strike,  slip,  rake is the default. DO NOT MIX types, e.g.,\n",
"     force plus moment tensor.\n",
"EXAMPLES:\n",
"\n",
"SEE\n",
""
};

char *help_mul[] = {
"\n",
"\n",
"GSAC Command Reference Manual                                 MUL\n",
"\n",
"SUMMARY:\n",
"     Multiply  all SAC data files in  memory by a constant.\n",
"\n",
"SYNTAX\n",
"     MUL [v],\n",
"\n",
"\n",
"INPUT:\n",
"     [v]      : constant by which all  files are multiplied\n",
"\n",
"SAC COMPATIBILITY:\n",
"     SAC  permits  an  extended syntax that permits applying different\n",
"     constants to respective files in memory. We have not  implemented\n",
"     this complexity.\n",
"DEFAULT:\n",
"     DIV 1\n",
"\n",
"SEE ALSO\n",
"     ADD, SUB, DIV\n",
""
};

char *help_mulf[] = {
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                                MULF\n",
"\n",
"SUMMARY:\n",
"     Multiply Files in memory\n",
"\n",
"     MULF  [Master n] [ Suffix suffix ] [ Default ]\n",
"\n",
"INPUT:\n",
"     Master         :  Trace uses as master trace. Default is 0, which\n",
"     is the first in memory.\n",
"     Suffix suffix : The traces are renamed and the original traces in\n",
"        memory are overwritten to be of the form\n",
"         [STA2][CMP2]_[STA1][CMP1].suffix. The default  value  of  the\n",
"        suffix is '.mul'\n",
"\n",
"DESCRIPTION:\n",
"     This  multiplies  all traces in memory by the master trace. After\n",
"     the multiplication operation  the  files  are  named  as  follow:\n",
"     [STA2][CMP2]_[STA1][CMP1].suffix  Beware  that nothing is done to\n",
"     the original header other than to reset the start and  end  times\n",
"     since  the  output  trace   is  only  for  the common overlapping\n",
"     absolute time window.\n",
"\n",
"     The result on the master trace is to square it,  and  perhaps  to\n",
"     change the begin and end of the trace.\n",
"HEADER CHANGES\n",
"     DEPMAX, DEPMIN, DEPMEN, NPTS, B, O\n",
"\n",
"EXAMPLES:\n",
"DEFAULT:\n",
"     MULF MASTER 0 Suffix .mul\n",
"SEE ALSO\n",
"     ADDF, SUBF, DIVF\n",
""
};

char *help_outcsv[] = {
"\n",
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                              OUTCSV\n",
"\n",
"SUMMARY:\n",
"     Output time series as CSV for spreadsheet\n",
"\n",
"INPUT:\n",
"\n",
"DESCRIPTION:\n",
"     This  writes  all  times  series  in  memory  in  ASCII to a file\n",
"     f001.csv, which consists of N+1 columns, where N is the number of\n",
"     traces in memory. Column 1  is  the  time  with  respect  to  the\n",
"     reference time, and the remaining columns are the samples.\n",
"\n",
"     This  program  handles  differing  time windows by outputting the\n",
"     common time segment, as is done by the commands rotate,  rotate3,\n",
"     addf, subf, mulf and divf.\n",
"\n",
"     The  number  of  data  points  (rows)  that  can  be  read into a\n",
"     spreadsheet is limited. For example OpenOffice only permits 65536\n",
"     rows.\n",
"\n",
"     This command was created to facilitate  student  manipulation  of\n",
"     traces using EXCEL or OpenOffice.\n",
"\n",
"EXAMPLES:\n",
"\n",
"SEE ALSO\n",
""
};

char *help_pause[] = {
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                               PAUSE\n",
"\n",
"SUMMARY:\n",
"     Pause a specified number of seconds\n",
"\n",
"     PAUSE Period delay\n",
"\n",
"INPUT:\n",
"     Period delay  : number of seconds to wait\n",
"DESCRIPTION:\n",
"     Termination  processing  until  the  time  delay  is  met. It was\n",
"     originally intended to await an ENTER/RETURN but this  would  not\n",
"     work  using  stdio  in  shell  scripts.   On could of course open\n",
"     /dev/console in UNIX/LINUX but this may not be transportable.\n",
"\n",
"     The purpose of this routine lies in using a shell script  to  run\n",
"     gsac. The combination of an ECHO followed by a PAUSE permits text\n",
"     to be read before proceeding with processing.\n",
"SAC COMPATIBILITY\n",
"     SAC also permits a y/n response for continuation.\n",
"\n",
"EXAMPLES:\n",
"\n",
"SEE ALSO\n",
"     ECHO\n",
""
};

char *help_pctl[] = {
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                                PCTL\n",
"\n",
"SUMMARY:\n",
"     Control time-domain plots\n",
"\n",
"     PCTL [options]\n",
"\n",
"INPUT:\n",
"     X0    x0       : X-position of lower left corner of plot\n",
"     Y0    y0       : Y-position of lower left corner of plot\n",
"     XLEn  xlen     : Length of x-axis\n",
"     YLen  ylen     : Length of y-axis\n",
"     XLAb  x-label  : Label for X-axis\n",
"     YLAb  y-label  : Label for Y-axis\n",
"     Width  width   : Trace width (nor axes)\n",
"     XN    xnumscl  : Multiply x-axis annotation by this factor\n",
"     YN    ynumscl  : Multiply y-axis annotation by this factor\n",
"     Grid  [ON|OFF]   :  Turn  positioning  grid  on/off.  This is for\n",
"        subplot alignment\n",
"     Default        : Reset to X0 1.5 Y0 1.0 XLEN 8.0 YLEN 6.0 XN  1.0\n",
"        YN 1.0\n",
"\n",
"DESCRIPTION:\n",
"     This  set  controls for the current plot. When used with the HOLD\n",
"     command, multiple figures can be displayed on a frame,\n",
"\n",
"EXAMPLES:\n",
"Default:\n",
"     X0 1.25 Y0 1.0 XLEN 8.0 YLEN 6.0 XLAB \"Time (s)\" YLAB  \"\"  XN\n",
"     1.0 YN 1.0 W 0.0\n",
"\n",
"SEE ALSO\n",
""
};

char *help_plot[] = {
"\n",
"\n",
"GSAC Command Reference Manual                               PLOT1\n",
"\n",
"SUMMARY:\n",
"     Plot traces\n",
"\n",
"     Plot1  [options]\n",
"INPUT:\n",
"     Perplot [n | OFF] :Plot n traces per plot frame\n",
"     Absolute          : Plot in absolute time\n",
"     Relative           :  Plot with all traces  starting at the first\n",
"        sample\n",
"     Overlay [ ON | OFF ] : Overlay all traces in current frame\n",
"\n",
"DESCRIPTION:\n",
"     When plotting the traces in more  than  one  window,  e.g.,  when\n",
"     using  the  perplot  option, the prompt asks is 'More? y/n/b' - A\n",
"     return or 'y' moves to the  next  plot,  an  'n'  terminates  the\n",
"     display,  and  the  'b'  returns to the previous set of displayed\n",
"     traces. This was introduced 02/27/2006 to facilitate  the  review\n",
"     of many traces.\n",
"\n",
"DEFAULT:\n",
"     PERPLOT OFF ABSOLUTE OVERLAY OFF\n",
"\n",
"SEE ALSO\n",
"     PLOTPK\n",
""
};

char *help_plotpk[] = {
"\n",
"\n",
"GSAC Command Reference Manual                              PLOTPK\n",
"\n",
"SUMMARY:\n",
"     Interactively work with traces\n",
"\n",
"PlotPK\n",
"\n",
"     The options are\n",
"\n",
"     Perplot  [n  | off]  : Plot n traces per frame or plot all on one\n",
"     frame (off)\n",
"     MARKALL            : Change headers for  all  traces  within  the\n",
"        plot  frame.  This is convenient for assigning the same P-pick\n",
"        time to all 3-components recorded at a station\n",
"     MARKALLOFF         : Turn off Markall - this is because we do not\n",
"        require a MARKALL ON\n",
"     Relative           : Plot traces according to time from the first\n",
"        sample\n",
"     Absolute           : Plot all traces in absolute time\n",
"     REGional           : Put up a simple regional phase menu\n",
"     Teleseism          : Put up a simple teleseism phase menu\n",
"     Quality            : Put up a simple quality control  menu\n",
"     PQuality           : Put up a simple quality  control   menu  and\n",
"        repick P\n",
"     Default            : Do not put up a phase menu, turn off marking\n",
"DESCRIPTION:\n",
"     The cursor responds to the following commands:\n",
"     -         : compress time scale by factor of 2, recenter trace\n",
"     _         : compress time scale by factor of 2, recenter trace\n",
"     +         : expand time scale by factor of 2, recenter trace\n",
"     =         : expand time scale by factor of 2, recenter trace\n",
"     (space) : recenter trace\n",
"     *         : increase trace amplitude by factor of 2\n",
"     m         : increase trace amplitude by factor of 2\n",
"     /         : decrease trace amplitude by factor of 2\n",
"     A         : accept (put +1 in IHDR20 for trace)\n",
"     R         : reject (put  0 in IHDR20 for trace)\n",
"     B         : move to the previous page of traces\n",
"     F       : insert a FINI marker (end of useful signal)\n",
"     L         : give time and amplitude of point beneath cursor\n",
"     N         : move to next set of traces\n",
"     O         : return to original trace scaling\n",
"     P         : mark P time\n",
"     S         : mark S time\n",
"     Q         : end interactive trace picking\n",
"     Tn        : set Tn header where n is a value from 0-9\n",
"                 Note that S sets T0. (Just enter T and then an integer)\n",
"     X         : Define trace window by entering X two times\n",
"     If  the  REGIONAL  or  TELESEISM  are flagged, a small phase menu\n",
"        appears: P S Pg Lg for regional phases and P  S  and  PKP  for\n",
"        teleseismic phases.  To use these menus, choose the phase from\n",
"        the  menu,  then  select  the  time  value from the trace, and\n",
"        classify the quality  of  the  arrival.  If  the  P  phase  is\n",
"        selected, then the first motion polarity must be indicated.\n",
"     The  Quality menu permits the use of the 'a' and 'r' keys to mark\n",
"        a trace for further use. In addition, the  default  action  of\n",
"        any  mouse press is to indicate accept, unless the Reject Menu\n",
"        button is pressed. Normally IHDR20 is set to -12345. An accept\n",
"        sets this to +1 and a  reject  to  -1.  If  a  WriteHeader  is\n",
"        executed,  then  the  trace headers are set to the new values,\n",
"        and  a  shell  script  can  then  select  traces  for  further\n",
"        processing.  The  purpose this command is to use gsac graphics\n",
"        to speedily judge trace quality for other processing.\n",
"     The Pquality menu works slightly  differently  from  the  Quality\n",
"        menu  in  that the objective is to select good traces and also\n",
"        to repick the P arrival. Just place the  crosshair  on  the  P\n",
"        arrival, click any mouse button and the P is repicked and  the\n",
"        trace is selected (IHDR20 is set to 1) with one click.\n",
"NOTE:\n",
"     On  July  10,  2010  the interactive cursor will respond to the ~\n",
"     (tilde)  character  by  creating  a   screen   dump   with   name\n",
"     DUMPxxx.PLT.  This  dump  includes  the menu and is introduced to\n",
"     assist documentation.\n",
"\n",
"SEE ALSO\n",
"     PLOT1\n",
""
};

char *help_plotsp[] = {
"\n",
"\n",
"GSAC Command Reference Manual                              PLOTSP\n",
"\n",
"SUMMARY:\n",
"     Plot spectra traces\n",
"\n",
"     PlotSP  [options]\n",
"INPUT:\n",
"\n",
"     AMplitude          : Plot amplitude spectrum (default)\n",
"     PHase              : Plot phase spectrum\n",
"     PErplot [n|OFF]    : Plot n spectra per frame (default off)\n",
"     OVerlay [ON|OFF]   : Overlay all spectra (default off)\n",
"     SMooth  [ON|OFF]     :  Apply  5  point  smoothing  to  amplitude\n",
"        spectrum\n",
"                             (default off)\n",
"     XLIn               : X-axis is linear\n",
"     XLOg               : X-axis is logarithmic (default)\n",
"     YLIn               : Y-axis is linear\n",
"     YLOg               : Y-axis is logarithmic (default)\n",
"     FMIn               : Minimum frequency for plot\n",
"                             (default: DF for XLOG and 0 for XLIN)\n",
"     FMAx               : Maximum frequency for plot\n",
"                             (default: Nyquist)\n",
"     AMIn               : Minimum spectral amplitude to plot (default:\n",
"                             0 for YLIN  and 0.0001 Amax for YLOG)\n",
"     AMAx               : Maximum spectral amplitude to plot\n",
"                             (default: maximum)\n",
"     Default            : Reset to default\n",
"\n",
"DESCRIPTION:\n",
"     After using the FFT command, the spectra  are  stored  in  memory\n",
"     along with the trace.\n",
"SAC Compatibility\n",
"     If  one  wishes  to  look  at the spectra and then the trace, SAC\n",
"     requires that the trace be reread. GSAC has both  in  memory,  so\n",
"     that one can alternate PLOT1 and PLOTSP to see the traces and the\n",
"     spectra.\n",
"\n",
"SEE ALSO\n",
"Notes\n",
"     The  plot  limits for this will be independent of the plot limits\n",
"     of the trace plots.\n",
""
};

char *help_psppk[] = {
"\n",
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                            PLOTSPPK\n",
"\n",
"SUMMARY:\n",
"     Interactive spectra pick\n",
"\n",
"PlotSPPK\n",
"INPUT\n",
"   AMplitude          : Plot amplitude spectrum (default)\n",
"   PHase              : Plot phase spectrum\n",
"   PErplot [n|OFF]    : Plot n spectra per frame (default off)\n",
"   OVerlay [ON|OFF]   : Overlay all spectra (default off)\n",
"   SMooth [ON|OFF]    : Apply 5 point smoothing to amplitude spectrum\n",
"                             (default off)\n",
"   XLIn               : X-axis is linear\n",
"   XLOg               : X-axis is logarithmic (default)\n",
"   YLIn               : Y-axis is linear\n",
"   YLOg               : Y-axis is logarithmic (default)\n",
"   FMIn               : Minimum frequency for plot\n",
"                             (default: DF for XLOG and 0 for XLIN)\n",
"   FMAx               : Maximum frequency for plot\n",
"                             (default: Nyquist)\n",
"   AMIn               : Minimum spectral amplitude to plot (default:\n",
"                             0 for YLIN  and 0.0001 Amax for YLOG)\n",
"   AMAx               : Maximum spectral amplitude to plot\n",
"                             (default: maximum)\n",
"   Default            : Do not put up a phase menu, turn off marking\n",
"DESCRIPTION:\n",
"     The cursor responds to the following commands:\n",
"     -         : compress frequency scale by factor of 2, recenter trace\n",
"     _         : compress frequency scale by factor of 2, recenter trace\n",
"     +         : expand frequency scale by factor of 2, recenter trace\n",
"     =         : expand frequency scale by factor of 2, recenter trace\n",
"     (space) : recenter trace\n",
"     B         : move to the previous page of traces\n",
"     L         : give frequency and amplitude of point beneath cursor\n",
"     N         : move to next set of traces\n",
"     O         : return to original trace scaling\n",
"     Q         : end interactive trace picking\n",
"     X         : Define trace window by entering X two times\n",
"     Z       : define frequency range for linear regression to get t*\n",
"SEE ALSO\n",
"     PLOTSP\n",
""
};

char *help_prs [] = {
"\n",
"\n",
"GSAC Command Reference Manual                   PLOTRECORDSECTION\n",
"\n",
"SUMMARY:\n",
"     Creates  a  record  section  of traces plotted as a function of a\n",
"     header value.\n",
"\n",
"     PlotRecordSection  hv  [LANDSCAPE|PORTRAIT|SEASCAPE|REVERSE]  and\n",
"     others\n",
"\n",
"INPUT:\n",
"     hv              : Use this header value. The default is DIST. One\n",
"     may select from the following: EVDP, STEL, GCARC, DIST, AZ,  BAZ,\n",
"     GCARC, USER0, ..., USER9,  MAG, STLA, STLO, EVLA and EVLO\n",
"     PORtrait: Time increases to the right. The header value increases\n",
"        upward.\n",
"     REVerse         :  Time  increases to the right. The header value\n",
"        increases downward.\n",
"     Landscape       :  Time  increases  upward.  The   header   value\n",
"        increases   to   the  right.  This  is  a  seismic  refraction\n",
"        convention.\n",
"     Seascape        :  Time  increases  downward.  The  header  value\n",
"        increases   to   the  right.  This  is  a  seismic  reflection\n",
"        convention.\n",
"     Absolute       : Plot in absolute time\n",
"     Relative       : Plot with all  traces   starting  at  the  first\n",
"        sample\n",
"     TItle  string    :  Title  for  axis. The Default titles are Dist\n",
"        (km/sec), Azimuth (deg), Back Azimuthy (deg,  Distance  (deg),\n",
"        USER0,  ..., USER9, Depth (km), Receiver depth, and Magnitude.\n",
"        This option is best used to substitute for USER0, ..., USER9\n",
"     P p            : Make p-tau plot by plotting T - p DIST  where  p\n",
"        =sec/km.\n",
"     PX p\n",
"     DTDX p\n",
"     PDEL dtdd      : Make p-tau plot by plotting T - dtdd GCARC\n",
"     DTDD dtdd\n",
"     AMP  amp         :  Change maximum amplitude of trace from 0.5 to\n",
"        amp units. Recall that the screen in 10 plot units wide and  8\n",
"        plot units high\n",
"     SHade  [POS|NEG|OFF|ALL] : Shaded area plot of trace for positive\n",
"        and negative amplitudes.\n",
"     Color color    : color for shading; Default = black (1). Red = 2,\n",
"        Blue = 4, 1000 (red/lt gray), 1100 (blue/dk gray).\n",
"     KF  first_trace_shade : shade color for first  trace  read  using\n",
"        Color convention\n",
"     KL   last_trace_shade   :  shade  color for last trace read using\n",
"        Color convention\n",
"     DEfault        : Reset all parameters\n",
"     VLimit vl vh   :\n",
"     TLimit tl th   :\n",
"     ANnotate string : Annotate trace. Use string =  STA  to  annotate\n",
"        with station name, NAME to annotate with file name or   OFF to\n",
"        turn off\n",
"     ScaleRelative   :   Each  trace  is plotted such that the maximum\n",
"        amplitude is always 'amp'\n",
"     ScaleAbsolute 0.0 :\n",
"     ScaleAbsolute 0.5 :\n",
"     ScaleAbsolute 1.0 :\n",
"     ScaleAbsolute 1.5 :\n",
"     ScaleAbsolute 2.0 :\n",
"     ScaleAbsolute 2.5 : Traces  are  scaled  according  as  hv^power,\n",
"        where  power  can  only be one of 0.5, 1.0, 1.5, 2.0, 2.5. The\n",
"        purpose is  to  present  the  difference  in  true  amplitudes\n",
"        between traces\n",
"     PIck  [ON|OFF]     :  Display values of A, T0,...,T9 markers that\n",
"        are set\n",
"     APIck [ON|OFF]   : Display values of A,  T0,...,T9  markers  that\n",
"        are set and names defined in KA KT0 ... KT9\n",
"\n",
"DESCRIPTION:\n",
"     The  purpose  of this is to create a plot that goes beyond simple\n",
"     trace view. It is often desirable to plot traces in terms of true\n",
"     distance to properly understand arrivals through  their  moveout.\n",
"     In  other cases one may wish to look at the variation of receiver\n",
"     functions.\n",
"\n",
"     If one uses the program saciterd to create a  receiver  function,\n",
"     the ray parameter is stored in the header variable USER4. To look\n",
"     at  the  change  in the receiver function with ray parameter, one\n",
"     would just enter\n",
"                  PRS USER4 To see the variation with backazimuth from\n",
"     the station, enter\n",
"                  PRS BAZ\n",
"\n",
"     Note that if the Origin time is set  and  the  Absolute  mode  is\n",
"     used,  then  the  time  axis  will  actually correspond to to the\n",
"     travel time instead of the time from the earliest time value.\n",
"\n",
"     Note also that if you wish to  overlay  observed  and  synthetics\n",
"     traces which have different reference times that you MUST use the\n",
"     PRS  RELATIVE command.  The PRS RELATIVE axis scaling is based on\n",
"     the B value of the first trace in memory.  PRS  RELATIVE  may  do\n",
"     strange things when using the P or PX commands, especially of the\n",
"     B  value is not consistently set, which it is, for example, using\n",
"     the iterative deconvolution program, saciterd.\n",
"DEFAULT:\n",
"     PRS DIST LANDSCAPE ABSOLUTE ScaleRelative\n",
"SEE\n",
"     PLOT1, PLOTPK, SORT\n",
""
};

char *help_qdp [] = {
"\n",
"\n",
"GSAC Command Reference Manual                                 QDP\n",
"\n",
"SUMMARY:\n",
"     Control decimation for screen plots.\n",
"\n",
"     QDP [ON|OFF|n]\n",
"\n",
"INPUT:\n",
"     ON       : Turn on automatic decimation\n",
"     OFF      : Turn off automatic decimation\n",
"     n        : Define the exact decimation\n",
"DESCRIPTION:\n",
"     This  controls  the  decimation factor used for screen plots. The\n",
"     purpose is to speed screen displays. When  OFF,  all  points  are\n",
"     plotted  in  the  current  window.  When  ON,  the  increment  is\n",
"     automatically determined to permit  no  more  than  4000  display\n",
"     points. The exact number used in the decimation can be controlled\n",
"     by the QDP n.\n",
"     To  permit  rapid  screening  of  the trace and yet to be able to\n",
"        consider the traces at its maximum resolution,  decimation  is\n",
"        turned  off  if  the  number  of  points  to be plotted in the\n",
"        current window is <= 4000. This is very useful  within  PLOTPK\n",
"        when  one wishes to focus on arrival exact arrival time picks,\n",
"        after quickly moving the trace.\n",
"     The plots resulting from a  BG  PLT  command  which  creates  the\n",
"        Pnnn.PLT CALPLOT files are not decimated.\n",
"     This  command was introduced since the CYGWIN plots under WINDOWS\n",
"        can be slower that the corresponding plot under LINUX  on  the\n",
"        same computer.\n",
"DEFAULT:\n",
"     QDP OFF\n",
"SEE ALSO\n",
"     PLOT1, PLOTPK\n",
""
};

char *help_read[] = {
"\n",
"\n",
"GSAC Command Reference Manual                                READ\n",
"\n",
"SUMMARY:\n",
"     Reads data from SAC data files on disk into memory.\n",
"\n",
"     Read [options] [filelist], or\n",
"\n",
"     where options is one or more of the following: MORE\n",
"\n",
"INPUT:\n",
"     MORE      :  Place  the  new files after the old ones. If this is\n",
"     omitted, new data replaces the old ones.\n",
"     [filelist] : name of SAC data files. The files in  the  list  are\n",
"        tested  to  determine if they are a binary file in either IEEE\n",
"        Little Endian  (INTEL architecture) or   Big  Endian   (SPARC,\n",
"        for example). Files are SAC files if the version number of the\n",
"        SAC  file  (NVHDR)  is  6  AND at least ONE of the real header\n",
"        values is -12345.0 or integer header values is -12345\n",
"SAC COMPATIBILITY:\n",
"     The MORE option differs in that a subsequent READ  will  read  in\n",
"     all  files.  Each  invocation of the READ MORE appends to list of\n",
"     SAC files in memory.\n",
"\n",
"SEE ALSO\n",
"     CUT\n",
""
};

char *help_rh[] = {
"\n",
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                             READHDR\n",
"\n",
"SUMMARY:\n",
"     Reads headers from SAC data files into memory.\n",
"\n",
"     ReadHdr [options] [filelist]\n",
"\n",
"     where options is one or more of the following: MORE\n",
"\n",
"INPUT:\n",
"     MORE      :  Place  the  new files after the old ones. If this is\n",
"     omitted, new data replaces the old ones. ALL HEADERS ARE READ  IN\n",
"     AGAIN\n",
"   filelist]  :  name  of  SAC  data  files. The files in the list are\n",
"        tested to determine if they are a binary file in  either  IEEE\n",
"        Little  Endian   (INTEL  architecture) or  Big Endian  (SPARC,\n",
"        for example). Files are SAC files if the version number of the\n",
"        SAC file (NVHDR) is 6 AND at least  ONE  of  the  real  header\n",
"        values is -12345.0 or integer header values is -12345\n",
"SAC COMPATIBILITY:\n",
"     The MORE option differs in that a subsequent READHDR will read in\n",
"     all files is the aggregate list.\n",
"DESCRIPTION:\n",
"     The  purpose  of  this  command is to speed making changes in the\n",
"     header by note reading in the complete timeseries.\n",
"\n",
"SEE ALSO\n",
"     READ\n",
""
};

char *help_refr[] = {
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                          REFRACTION\n",
"\n",
"SUMMARY:\n",
"     Enter Refraction Processing Mode for Record Section\n",
"\n",
"     REFRaction [ON|OFF] [Ex|Reg|Tel]\n",
"\n",
"INPUT:\n",
"\n",
"DESCRIPTION:\n",
"     This   places   the   PLOTRECORDSECTION  (prs)  display  into  an\n",
"     interactive mode for refraction studies.\n",
"\n",
"     Ultimately we will have data structure for the arrivals, and when\n",
"     gsac terminates these will be written to an ASCII file.  Also  if\n",
"     REFRACTION is even invoked, then the picked refraction lines will\n",
"     be  displayed  on the screen using an XOR pen - this is useful if\n",
"     one leaves PRS -- or if reread then get rid of everything - think\n",
"     about all of this, perhaps we need a save  button  instead  of  a\n",
"     data structure\n",
"     Ex  -  Exploration  mode - Filter frequencies are 10, 20, 30, 40,\n",
"        50, 60, 70, 80, 90, 100, 150, 200, 250, 500, 1000 Hz\n",
"     Reg - Regional mode - Filter frequencies are 1, 2, 3, 4, 5, 6, 7,\n",
"        8, 9, 10, 15, 20, 25, 50, 100 Hz\n",
"     Tel - Teleseism mode - Filter frequencies are 0.01,  0.02,  0.03,\n",
"        0.04,  0.05,  0.06,  0.07,  0.08, 0.09, 0.10, 0.15, 0.2, 0.25,\n",
"        0.5, 1 Hz\n",
"EXAMPLES:\n",
"     The terminal text output of the DoRefr command is  the  following\n",
"     if the value is accepted:\n",
"      S: Refr t0 -0.005536 p 6.474635 (sec/km) Vel 0.154449 (km/sec) Refractor 1\n",
"      S: Refr t0 0.159714 p 0.513774 (sec/km) Vel 1.946381 (km/sec) Refractor 2\n",
"\n",
"     which indicates that these are S-wave refraction measurements for\n",
"     the  first  two refraction arrivals. This information can be used\n",
"     in a simple program to compute layer thicknesses.\n",
"\n",
"     The terminal text output of the DoRefl command is  the  following\n",
"     if the value is accepted:\n",
"     S: Refl t0 0.154164 p 6.384913 (sec/km) Vrms 0.156619 (km/sec) Reflector 1 Multiple 1\n",
"     S: Refl t0 0.308500 p 5.856309 (sec/km) Vrms 0.170756 (km/sec) Reflector 1 Multiple 2\n",
"     These values can be used to determine layer thicknesses.\n",
"\n",
"     For  each PRS001.PLT or REFR001.PLT file there is a corresponding\n",
"     PRS001.CTL or REFR001.CTL control file,  which  can  be  used  to\n",
"     invoke the program refmod96 to make model predicted overlays.\n",
"\n",
"     In addition there is a refrpick.tmp file which will ultimately be\n",
"     used by an inversion program.\n",
"NOTE:\n",
"     On  July  10,  2010  the interactive cursor will respond to the ~\n",
"     (tilde)  character  by  creating  a   screen   dump   with   name\n",
"     DUMPxxx.PLT.  This  dump  includes  the menu and is introduced to\n",
"     assist documentation.\n",
"\n",
"\n",
"\n",
"SEE ALSO\n",
""
};

char *help_rev[] = {
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                             REVERSE\n",
"\n",
"SUMMARY:\n",
"     Reverse Time Series\n",
"\n",
"     REVERSE [Suffix suffix]\n",
"\n",
"INPUT:\n",
"     Suffix   : suffix for the files names. The default is .rev\n",
"DESCRIPTION:\n",
"     This routine reverses the time sequence in place. The time header\n",
"     values with respect to timing are changed to reflect the absolute\n",
"     reversal in time:\n",
"\n",
"EXAMPLE\n",
"HEADER VALUES SET:\n",
"     B,E, A, O, T0, T1, ..., T9, NZYEAR, NZJDAY, NZHOUR, MZMIN, NZMSEC\n",
"SEE ALSO\n",
""
};

char *help_ricker[] = {
"\n",
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                              RICKER\n",
"\n",
"SUMMARY:\n",
"     Convolve with Ricker wavelet\n",
"\n",
"     RIcker F frequency [Default]\n",
"\n",
"INPUT:\n",
"     F frequency :  the frequency of the Ricker wavelet\n",
"\n",
"DESCRIPTION:\n",
"     The Ricker wavelet with frequency 'f' is defined as follows:\n",
"\n",
"     f(t) = [ 1 - 0.5 * (2 pi t t )^2 ] exp [ - ( pi f t )^2]\n",
"\n",
"\n",
"Default:\n",
"     RIcker F 25\n",
"\n",
"SEE ALSO\n",
"     TRIANGLE, TRAPEZOID, BOXCAR\n",
""
};

char *help_rmean[] = {
"\n",
"\n",
"GSAC Command Reference Manual                               RMEAN\n",
"\n",
"SUMMARY:\n",
"     Remove mean from waveform\n",
"\n",
"RMEAN\n",
"\n",
"DESCRIPTION:\n",
"     This removes the trace mean from the trace.\n",
"\n",
"SEE ALSO\n",
"     RTREND\n",
""
};

char *help_rot [] = {
"\n",
"\n",
"GSAC Command Reference Manual                              ROTATE\n",
"\n",
"SUMMARY:\n",
"     Rotates horizontal components through and angle\n",
"\n",
"     ROTate [ TO GC | TO angle ] [ Suffix suffix ]\n",
"\n",
"INPUT:\n",
"     TO  GC           : Rotate to the great circle path. This requires\n",
"     that the BAZ and CMPAZ header variable be set. The KCMPNM headers\n",
"     are changed to replace the last character, usually N and E, to  R\n",
"     and T. In addition the file name for default changes\n",
"     TO  angle         :  Rotate  to form the trace in the {angle} and\n",
"        {angle + 90} directions. this requires that the CMPAZ  be  set\n",
"        in  the  header  The  KCMPNM  headers  are  changed as are the\n",
"        default write names.\n",
"     Suffix suffix   : Append the suffix to the constructed file name.\n",
"        This is useful when the command is followed by  WRITE  without\n",
"        any arguments.\n",
"DESCRIPTION:\n",
"     In  both  uses  of  the  command,  the  filename  and  KCMPNM are\n",
"     converted to upper case. Note that a write will be in the current\n",
"     directory rather in the directory of the original traces.\n",
"     As an added feature, ROTATE is smart enough to handle traces that\n",
"        do not have equal lengths or absolute  start  time.  The  will\n",
"        consist  of  the  overlapped  trace window. This means that it\n",
"        should be possible to ROTATE without having to SYNCHRONIZE and\n",
"        CUT\n",
"     The following dialog illustrates  the  naming,  Recall  that  the\n",
"        LISTHEADER gives the filename for the default write.\n",
"\n",
"        GSAC> r ../020618/BLOLHN.sac ../020618/BLOLHE.sac\n",
"        GSAC> lh cmpaz cmpinc az baz\n",
"                   AZ             39.23643          BAZ             220.0237\n",
"                CMPAZ                    0       CMPINC                   90\n",
"                   AZ             39.23643          BAZ             220.0237\n",
"                CMPAZ                   90       CMPINC                   90\n",
"        GSAC> rotate to gc\n",
"        Rotating to great circle to form R and T\n",
"        GSAC> lh\n",
"        BLOLHR (0):\n",
"                   AZ             39.23643          BAZ             220.0237\n",
"                CMPAZ             40.02368       CMPINC                   90\n",
"        BLOLHT (1):\n",
"                   AZ             39.23643          BAZ             220.0237\n",
"                CMPAZ             130.0237       CMPINC                   90\n",
"        GSAC> rotate to 40\n",
"        Rotating to angle 40.000000 to form 040 and 130\n",
"        GSAC> lh\n",
"        BLOLH040 (0):\n",
"                   AZ             39.23643          BAZ             220.0237\n",
"                CMPAZ                   40       CMPINC                   90\n",
"        BLOLH130 (1):\n",
"                   AZ             39.23643          BAZ             220.0237\n",
"                CMPAZ                  130       CMPINC                   90\n",
"HEADER VALUES SET:\n",
"     The  CMPAZ  is  properly  set  to  each rotated component. If the\n",
"     components are rotated to the great circle (GC), then  CMPAZ  for\n",
"     the  resulting radial component is BAZ+180 and for the transverse\n",
"     component is BAZ + 270.\n",
"\n",
"     If the angle is given, then the positive motion will  be  in  the\n",
"     direction of the angle given in the file name.\n",
"\n",
"     After  the rotate command the order of traces in memory is radial\n",
"     and transverse, or AZ and AZ + 90.\n",
"\n",
"SEE ALSO\n",
""
};

char *help_rot3[] = {
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                             ROTATE3\n",
"\n",
"SUMMARY:\n",
"     Rotate three components to form Z and horizontals or UVW\n",
"\n",
"\n",
"     ROTate3 [ TO GC | TO angle | TO UVWSTS2 | UVWTRIL | ZNE] [ Suffix\n",
"     suffix ]\n",
"\n",
"INPUT:\n",
"     TO  GC          :  Rotate to the great circle path. This requires\n",
"     that the BAZ and CMPAZ header variable be set. The KCMPNM headers\n",
"     are changed to replace the last character, usually N and E, to  R\n",
"     and T. In addition the file name for default changes\n",
"     TO  angle       :  Rotate  to  form  the trace in the {angle} and\n",
"        {angle + 90} directions. this requires that the CMPAZ  be  set\n",
"        in  the  header  The  KCMPNM  headers  are  changed as are the\n",
"        default write names.\n",
"     TO UVWSTS2        : Rotate x (E) y (N) z (up) to UVW for STS-2\n",
"     TO UVWTRIL        : Rotate x (E) y (N) z (up) to UVW for Trillium\n",
"             The difference between the two conversions to UVW is that\n",
"             U(STS2) == U(TRIL) rotated horizontally 180 degrees\n",
"             V(STS2) == W(TRIL) rotated horizontally 180 degrees\n",
"             W(STS2) == V(TRIL) rotated horizontally 180 degrees\n",
"     TO ZNE             : Rotate to ZNE. This is useful if one as  UVW\n",
"        or event ZRT and wants a nice clean naming of the output.\n",
"     Suffix  suffix  : Append the suffix to the constructed file name.\n",
"        This is useful when the command is followed by  WRITE  without\n",
"        any arguments.\n",
"DESCRIPTION:\n",
"     This  is  an  extension of the ROTATE command that uses all three\n",
"     components to form the three rotated components. Although it  may\n",
"     seem  redundant  to include the vertical component in a rotation,\n",
"     this is useful if the CMPINC of the vertical  component  in  180,\n",
"     meaning  that  the  positive  trace value is down rather than the\n",
"     desired up. At the same time, the use of ROTATE3  (ROT3)  ensures\n",
"     that the three component have the same default naming convention,\n",
"     e.g., SLMBHR, SLMBHT and SLMBHZ.\n",
"     In  both  uses  of  the  command,  the  filename  and  KCMPNM are\n",
"        converted to upper case. Note that a  write  will  be  in  the\n",
"        current  working   directory  rather  in  the directory of the\n",
"        original traces.\n",
"     As an added feature, ROTATE3 is smart  enough  to  handle  traces\n",
"        that  do  not  have  equal lengths or absolute start time. The\n",
"        will consist of the overlapped trace window. This  means  that\n",
"        it  should be possible to ROTATE without having to SYNCHRONIZE\n",
"        and CUT\n",
"\n",
"HEADER VALUES SET:\n",
"     The CMPAZ  and CMPINC are properly set to each rotated component.\n",
"     If the components are rotated to  the  great  circle  (GC),  then\n",
"     CMPAZ  for  the resulting radial component is BAZ+180 and for the\n",
"     transverse component is BAZ + 270.\n",
"\n",
"     If the angle is given, then the positive motion will  be  in  the\n",
"     direction of the angle given in the file name.\n",
"\n",
"     The  default  order  of  the  traces  in  memory  is  radial (R),\n",
"     transverse (T) and vertical (Z), AZ, AZ+90 and vertical (Z). Thus\n",
"     the default WRITE would  identical to the command\n",
"          w SLMBHR SLMBHT SLMBHZ\n",
"     for example. When the conversion to UVW is requested, the default\n",
"        write would be the same as the command\n",
"          w SLMBHY SLMBHV SLMBHW\n",
"\n",
"SEE ALSO\n",
"     ROTATE\n",
""
};

char *help_rtr[] = {
"\n",
"\n",
"GSAC Command Reference Manual                              RTREND\n",
"\n",
"SUMMARY:\n",
"     Remove linear trend from waveform\n",
"\n",
"     RTRend\n",
"INPUT:\n",
"     None.\n",
"DESCRIPTION:\n",
"     This  fits a straight line through the data and removes the trend\n",
"     by a simple least squares algorithm.\n",
"\n",
"SEE ALSO\n",
"     RMEAN\n",
""
};

char *help_sgn[] = {
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                                 SGN\n",
"\n",
"SUMMARY:\n",
"     SGN\n",
"\n",
"\n",
"INPUT:\n",
"\n",
"DESCRIPTION:\n",
"     This implements a 1-bit digitization according to the rule\n",
"\n",
"          b(t) = +1 for s (t) >=0\n",
"\n",
"          b(t) = -1 for s (t) < 0\n",
"\n",
"     The DEPMAX and DEPMIN are reset. Note for this to work one should\n",
"     perform a rmean prior to invocation.\n",
"References\n",
"     Derode,  A.,  A.  Tourin  and  M.  Fink  (1999). Ultrasonic pulse\n",
"     compression  with  one-bit   time   reversal   through   multiple\n",
"     scattering, J. Appl. Phys. 85, No 9, 6343-6352.\n",
"\n",
"EXAMPLES:\n",
"\n",
"SEE ALSO\n",
""
};

char *help_shift[] = {
"\n",
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                               SHIFT\n",
"\n",
"SUMMARY:\n",
"     Shift trace in time\n",
"\n",
"     SHIFT Fixed sec\n",
"\n",
"INPUT:\n",
"     Fixed amount    : Shift the trace by amount seconds.\n",
"\n",
"DESCRIPTION:\n",
"     The  purpose  of this is to adjust synthetics for a source delay.\n",
"     If the amount is positive, then the trace is shifted to be  later\n",
"     in time.  This is accomplished by changing the B and E parameters\n",
"     in  the header. In addition all arrival time picks, such as A, T0\n",
"     ... T9 are adjusted also. The origin time offset is NOT changed.\n",
"\n",
"EXAMPLES:\n",
"\n",
"SEE ALSO\n",
""
};

char *help_smth[] = {
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                              SMOOTH\n",
"\n",
"SUMMARY:\n",
"     Apply a smoothing operator\n",
"\n",
"     SMOOTH [MEAn|MEDian] [Halfwidth n ] [Pass p] [Default}\n",
"\n",
"INPUT:\n",
"     MEAN (default) : Apply an averaging operator\n",
"     MEDIAN         : Apply a median filter\n",
"     Halfwidth  n     :  Smoothing  operator  consists  of 2n+1 points\n",
"        (default 1)\n",
"     Pass p         : Apply the operator p times\n",
"     Default        : Reset to MEAN Halfwidth 1 Pass 1\n",
"\n",
"\n",
"DESCRIPTION:\n",
"\n",
"SAC COMPATIBILITY:\n",
"     The Pass option is new.\n",
"DEFAULT:\n",
"     SMOOTH MEAN HALFWIDTH 1 PASS 1\n",
"\n",
"SEE ALSO\n",
"     ABS, ENV\n",
""
};

char *help_sort [] = {
"\n",
"\n",
"GSAC Command Reference Manual                                SORT\n",
"\n",
"SUMMARY:\n",
"     Sort all displays by the key\n",
"\n",
"     SORT  [OFF|DEFAULT]  [UP|DOWN] [FORWARD|REVERSE] [ASCEND|DESCEND]\n",
"     header_variable\n",
"\n",
"INPUT:\n",
"     header_variable       : The header value to be  sorted,  e.g,  O,\n",
"     DIST, GCARC, etc.\n",
"     UP, ASCEND, FORWARD   : Sort in order of increasing value so that\n",
"        a LISTHEADER header_variable gives the smallest value first\n",
"     DOWN, DESCEND, REVERSE: Sort in order of decreasing value so that\n",
"        a LISTHEADER header_variable gives the largest value first\n",
"     OFF, DEFAULT          : Do not sort\n",
"DESCRIPTION:\n",
"     This  sorts  the trace display according to the value of key.  To\n",
"     sort on distance,\n",
"     sort dist\n",
"     If USER4 has a ray parameter from saciterd, then\n",
"\n",
"        sort user4 plot1\n",
"     will display the traces in order of the ray parameter.\n",
"\n",
"        At present only a sort on the integer or floating point header\n",
"        values is implemented.\n",
"\n",
"SEE ALSO\n",
"     LISTHEADER\n",
""
};

char *help_sqr [] = {
"\n",
"\n",
"GSAC Command Reference Manual                                 SQR\n",
"\n",
"SUMMARY:\n",
"     Square each data point of the trace\n",
"\n",
"SQR\n",
"\n",
"INPUT:\n",
"\n",
"DESCRIPTION:\n",
"\n",
"SEE ALSO\n",
"     SQRT, ABS\n",
""
};

char *help_sqrt [] = {
"\n",
"\n",
"GSAC Command Reference Manual                                SQRT\n",
"\n",
"SUMMARY:\n",
"     Take the square root of each data point in the trace.\n",
"\n",
"SQRT\n",
"\n",
"INPUT:\n",
"\n",
"DESCRIPTION:\n",
"     Take the square root of a trace. Note this fails if a trace value\n",
"     is < 0.0.\n",
"SEE ALSO\n",
"     SQR, ABS\n",
""
};

char *help_stack[] = {
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                               STACK\n",
"\n",
"SUMMARY:\n",
"     Stack traces\n",
"\n",
"     STACK [Relative|Absolute] [Norm On | Off ] [Suffix suffix]\n",
"\n",
"INPUT:\n",
"     Relative      : stack according to first sample. Output length is\n",
"     controlled by smallest time window\n",
"     Absolute      : Stack in absolute time. Output window is based on\n",
"        latest begin time and earliest end time.\n",
"     Norm  On  |  Off : If on divide the stack by the number of traces\n",
"        used\n",
"     Suffix        : suffix for the files names. The default is .stk\n",
"\n",
"DESCRIPTION:\n",
"\n",
"EXAMPLES:\n",
"\n",
"DEFAULT:\n",
"     STACK ABSOLUTE NORM OFF\n",
"\n",
"HEADER CHANGES:\n",
"     DEPMIN, DEPMAX, DEPMEN. IHDR11 is set to  the  number  of  traces\n",
"     actually stacked.\n",
"\n",
"SEE ALSO\n",
"     CORRELATE\n",
""
};

char *help_sub[] = {
"\n",
"\n",
"GSAC Command Reference Manual                                 SUB\n",
"\n",
"SUMMARY:\n",
"     Subtract a constant to  all SAC data files in  memory.\n",
"\n",
"     SUB [v]\n",
"INPUT:\n",
"     [v]      : constant to be subtracted to all files\n",
"\n",
"SAC COMPATIBILITY:\n",
"     SAC  permits  an  extended syntax that permits applying different\n",
"     constants to respective files in memory. We have not  implemented\n",
"     this complexity.\n",
"DEFAULT\n",
"     SUB 0\n",
"\n",
"SEE ALSO\n",
"     ADD, MUL, DIV\n",
""
};

char *help_subf[] = {
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                                SUBF\n",
"\n",
"SUMMARY:\n",
"     Subtract Files in memory\n",
"\n",
"     SUBF  [Master n] [ Suffix suffix ] [ Default ]\n",
"\n",
"INPUT:\n",
"     Master         :  Trace uses as master trace. Default is 0, which\n",
"     is the first in memory.\n",
"     Suffix suffix : The traces are renamed and the original traces in\n",
"        memory are overwritten to be of the form\n",
"         [STA2][CMP2]_[STA1][CMP1].suffix. The default  value  of  the\n",
"        suffix is '.sub'\n",
"\n",
"DESCRIPTION:\n",
"     This subtracts the master trace from all traces  in memory. After\n",
"     the  subtraction  operation,  the  files  are  named  as  follow:\n",
"     [STA2][CMP2]_[STA1][CMP1].suffix Beware that nothing is  done  to\n",
"     the  original  header other than to reset the start and end times\n",
"     since the output  trace   is  only  for  the  common  overlapping\n",
"     absolute time window.\n",
"\n",
"HEADER CHANGES\n",
"     DEPMAX, DEPMIN, DEPMEN, NPTS, B, O\n",
"\n",
"EXAMPLES:\n",
"DEFAULT:\n",
"     SUBF MASTER 0 Suffix .sub\n",
"SEE ALSO\n",
"     ADDF, MULF, DIVF\n",
""
};

char *help_sync [] = {
"\n",
"\n",
"GSAC Command Reference Manual                         SYNCHRONIZE\n",
"\n",
"SUMMARY:\n",
"     Synchronize reference times\n",
"\n",
"     SYNChronize o | a | b | e | o\n",
"\n",
"INPUT:\n",
"     o        : set the reference time as the origin time\n",
"     a        : set the reference time as the P arrival time\n",
"     b        : set the reference time as the fist sample\n",
"\n",
"DESCRIPTION:\n",
"     The  purpose  of  this command is to make the reference times the\n",
"     same for  all  traces  in  memory.  It  determines  the  earliest\n",
"     absolute  starting time of all files, and sets the B time of that\n",
"     file to 0.0. The B times of other files are  then  always  >0  =.\n",
"     Although  SAC  used the latest start time, ours ensures that B is\n",
"     never set to the magic -12345.\n",
"\n",
"     As a result of this operation, any marked times, e.g., B,  E,  O,\n",
"     A,  Tn,  F  are result so that the absolute time of these markers\n",
"     are not changed.\n",
"\n",
"     A previous use for this was to ensure  that  MARKALL  and  ROTATE\n",
"     will work properly. GSAC works with absolute time.\n",
"\n",
"     The  reason  for  the O ( oh - origin time ) option is to set the\n",
"     origin  time  as  the  reference  time.  This  is   useful   when\n",
"     documenting  events  -  just use saclhdr with the -KZDATE -KZTIME\n",
"     options. The reuslt is that the arrival offsets A,  T0,  ...,  T9\n",
"     will then be the travel times. The sequence\n",
"          GSAC> set o\n",
"          GSAC> set a P_travel time\n",
"     This  is an easy way to set the phase arrival time. Otherwise one\n",
"     would ahve to add the travel time to the origin time offset.\n",
"\n",
"     The reason for the A option  is  to  align  waveforms  on  the  P\n",
"     arrival  in  a  two  step  process. First this option changes the\n",
"     reference times so that the A header value is zero. Then one  can\n",
"     use a\n",
"     ch NZYEAR year NZJDAY jday NZHOUR hour NZMIN min NZSEC sec NZMSEC\n",
"        msec\n",
"     to  change  the  reference  time. This is one way to overcome bad\n",
"        timing on the individual channels.\n",
"SEE ALSO\n",
""
};

char *help_taper[] = {
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                               TAPER\n",
"\n",
"SUMMARY:\n",
"      Apply a symmetric taper to ends of traces\n",
"\n",
"     TAPER [Cosine|HANning|HAMming] [WIDTH w]\n",
"\n",
"INPUT:\n",
"     Cosine   : apply a cosine taper to each end of the trace.\n",
"     HANning  : apply a Hanning taper\n",
"     HAMming  : apply a Hamming taper\n",
"     WIDTH w  : Taper width of as a function of the entire trace. This\n",
"        is  a  value between 0.0 and 0.5. If the first and last 25% of\n",
"        the trace are to be tapered, w = 0.25. w = 0 implies no taper.\n",
"        If a value of w is > 0.5, 0.5 is used; if  w  <  0.0,  0.0  is\n",
"        used.\n",
"\n",
"DESCRIPTION:\n",
"     The taper function taper(x) varies from  [0,1] as t varies in the\n",
"     range [0,1]. The mathematical definitions of the function is:\n",
"     taper(x) = A + B FUN (C x)\n",
"     where\n",
"                  Taper        A      B      FUN  C\n",
"                  COSINE      0.0    1.0     sin PI/2\n",
"                  HAMMING     0.54  -0.46    cos PI     [note taper(0) = 0.08 ]\n",
"                  HANNING     0.5   -0.5     cos PI\n",
"HEADER\n",
"     DEPMAX, DEPMIN, DEPMEN\n",
"DEFAULT:\n",
"     TAPER HANNING W 0.05\n",
"\n",
"SEE ALSO\n",
""
};

char *help_title[] = {
"\n",
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                               TITLE\n",
"\n",
"SUMMARY:\n",
"     This command defines the title for a plot\n",
"\n",
"     Title    [ON|OFF]   [Location   Top|Bottom|Right|Left   ]   [Size\n",
"     Tiny|Small|Medium|Large] [Default] Text text\n",
"\n",
"\n",
"INPUT:\n",
"     Location Top|Bottom|Right|Left  : Position of title with  respect\n",
"     to plot frame\n",
"   Size  Tiny|Small|Medium|Large     :  Size of characters - these are\n",
"        scaled to a fraction of the plot dimensions\n",
"   Default                         : Reset all parameters\n",
"   ON|OFF                          : turn the title on or off\n",
"   Text text                       : the title text. Note that if  the\n",
"        text contains spaces it must be in within quotes.\n",
"\n",
"DESCRIPTION:\n",
"     If  this  option  is  on,  a title can be placed on the plot.  Of\n",
"     course, if the CALPLOT graphic file is converted to  Encapsulated\n",
"     PostScript,  then  the title can be added using the programs xfig\n",
"     or Illustrator.\n",
"SAC COMPATIBILITY:\n",
"     Note that sac2000 does not require the text to be  defined  by  a\n",
"     keyword.   gsac  requires  that the title be keyed using the Text\n",
"     keyword.\n",
"\n",
"DEFAULT:\n",
"     Title OFF Location Top Size Small Text None\n",
"\n",
"SEE ALSO\n",
""
};

char *help_trans [] = {
"\n",
"\n",
"GSAC Command Reference Manual                            TRANSFER\n",
"\n",
"SUMMARY:\n",
"     Apply or remove an instrument response/filter from the data\n",
"\n",
"     TRANSfer  [FROM|TO]  [Polezero  SUBTYPE  pzfile] [FApfile SUBTYPE\n",
"     fapfile] [evaL SUBTYPE afile pfile] [ ACC | VEL | DISP ]\n",
"              [FREQlimits f1 f2 f3 f4]\n",
"\n",
"INPUT:\n",
"     FROM                     : Deconvolve the filter from the trace\n",
"     TO                       : Convolve the filter with the trace\n",
"     Polezero SUBTYPE pzfile  : Use SAC pole-zero format\n",
"     Eval SUBTYPE afile pfile : Use output of  IRIS  evalresp  program\n",
"        which  creates  two  files, each of two columns. The afile has\n",
"        columns of frequency and  amplitude  in  order  of  increasing\n",
"        frequency.  The  pfile  has  columns  of  frequency  and phase\n",
"        (degrees) in order of increasing frequency.\n",
"     FApfile SUBTYPE fapfile  : a GSE frequency amplitude period file\n",
"     ACC | VEL | DISP         : an internal type -\n",
"     basically ACC means multiply/divide by ( i omega )^2 for TO/FROM\n",
"     basically VEL means multiply/divide by ( i omega ) for TO/FROM\n",
"     basically DISP means multiply/divide by ( 1  ) for TO/FROM\n",
"     FREQlimits f1 f2 f3 f4   : Apply a cubic taper  to  the  response\n",
"        such the response is 0 for f < f1 and for f > f4, the response\n",
"        is 1 for f > f2 and for f < f3, and tapers cubically from 0 to\n",
"        1  for f1 < f < f2 and f4 > f > f3.  Note the only way to turn\n",
"        this off is to reset the limits as in FREQLIMITS -2  -1  1.0e5\n",
"        1.0e6  FREQLIMITS  is  only used in the FROM process.  This is\n",
"        essential for a clean deconvolution\n",
"\n",
"DESCRIPTION:\n",
"\n",
"SAC COMPATIBILITY:\n",
"     This does not support the many built-in instrument  responses  of\n",
"     SAC.  Instead the user must define the corresponding pole-zero or\n",
"     response file.\n",
"\n",
"     The EVAL option is different than SAC. Instead of working with  a\n",
"     seed  database,  GSAC  expects  the  user  to  have  already  run\n",
"     'evalresp' independently to create two files with names  such  as\n",
"     AMP.NM.SLM..BHZ, and PHASE.NM.SLM..BHZ\n",
"\n",
"     The FAP file can have a line start with a # to indicate a comment\n",
"     line.  The lines following the # signs are essential, however the\n",
"     count of the number of entries is ignored by GSAC. An example  of\n",
"     this format is\n",
"      # Velocity response for INCN BHZ\n",
"      #\n",
"      #\n",
"      #\n",
"      # Phase unwrapped\n",
"      #\n",
"       theoretical  0   instrument    fap Organization\n",
"      40\n",
"       0.100000E-02  0.141401E+09  0.149665E+03  0.000000E+00  0.000000E+00\n",
"       0.100926E-02  0.143988E+09  0.149365E+03  0.000000E+00  0.000000E+00\n",
"       0.101861E-02  0.146621E+09  0.149061E+03  0.000000E+00  0.000000E+00\n",
"       0.102804E-02  0.149300E+09  0.148754E+03  0.000000E+00  0.000000E+00\n",
"       0.103757E-02  0.152025E+09  0.148443E+03  0.000000E+00  0.000000E+00\n",
"\n",
"     For compatibility with SAC, the SUBTYPE field MUST be used.\n",
"\n",
"     Note that the use of DISP, VEL or ACC with any operation requires\n",
"     that  the  user  know  what  the  original  filter relates, e.g.,\n",
"     counts/meter\n",
"\n",
"HEADER VALUES SET:\n",
"     USER1 = permin,  USER2=permax,  where  permin=MAX[1.0/filt_f3,old\n",
"     permin]  and  permax=MIN[1./filt_f2,old  permax]. This feature is\n",
"     used by sacmft96 and sacpom96\n",
"SEE ALSO\n",
"     FILTER\n",
""
};

char *help_trapezoid[] = {
"\n",
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                           TRAPEZOID\n",
"\n",
"SUMMARY:\n",
"     Convolve with unit area trapezoid\n",
"\n",
"     TRAPEZOID Width L1 L2 L3\n",
"INPUT:\n",
"     Width  L1  L2  L3  :  L1, L2 and L3 define the trapezoidal pulse.\n",
"     These values are adjusted to lie on a sample with.\n",
"DESCRIPTION:\n",
"     Convolve the time series in memory with a unit  area  trapezoidal\n",
"     pulse.\n",
"\n",
"     This acts as a lowpass filter.\n",
"\n",
"     If L1 + L2 + L2 < 2*DELTA, nothing is done\n",
"EXAMPLES:\n",
"\n",
"SEE ALSO\n",
"     TRIANGLE, BOXCAR, RICKER\n",
""
};

char *help_triangle[] = {
"\n",
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                            TRIANGLE\n",
"\n",
"SUMMARY:\n",
"     Convolve with unit area triangle\n",
"\n",
"     TRIANGLE  [ Half half_width ] [ Width width ]\n",
"\n",
"INPUT:\n",
"     Half  half-width  :  the  half-width  of  the  isosceles triangle\n",
"     function rounded to the next sample interval.\n",
"   Width width : the base width of  the  isosceles  triangle  function\n",
"        rounded to the next sample interval.\n",
"DESCRIPTION:\n",
"     This  routine  convolves  all  traces  in memory with a unit area\n",
"     isosceles triangular pulse.  This command is equivalent to\n",
"\n",
"               TRAPEZOID WIDTH half_width 0.0 half_width\n",
"\n",
"               TRAPEZOID WIDTH width/2 0.0 width/2\n",
"\n",
"     This acts as a lowpass filter.\n",
"\n",
"     If half_width < DELTA, no filtering is done\n",
"EXAMPLES:\n",
"\n",
"SEE ALSO\n",
"     TRAPEZOID, BOXCAR, RICKER\n",
""
};

char *help_v[] = {
"\n",
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                             VERSION\n",
"\n",
"SUMMARY:\n",
"     Print GSAC version number\n",
"\n",
"     Version\n",
"\n",
"INPUT:\n",
"\n",
"DESCRIPTION:\n",
"\n",
"EXAMPLES:\n",
"\n",
"SEE ALSO\n",
""
};

char *help_whit[] = {
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                              WHITEN\n",
"\n",
"SUMMARY:\n",
"     Whiten signal\n",
"\n",
"     WHITEN [DEFAULT] [FREQlimits f1 f2 f3 f4] [Absolute]\n",
"\n",
"\n",
"INPUT:\n",
"     DEFAULT  : initialize frequency limits\n",
"     FREQlimits  f1  f2  f3  f4  : Apply a cubic taper to the response\n",
"        such the response is 0 for f < f1 and for f > f4, the response\n",
"        is 1 for f > f2 and for f < f3, and tapers cubically from 0 to\n",
"        1 for f1 < f < f2 and f4 > f > f3.  Note the only way to  turn\n",
"        this  off  is to reset the limits as in FREQLIMITS -2 -1 1.0e5\n",
"        1.0e6 This may eliminate the need for a bandpass following the\n",
"        whitening.\n",
"     Absolute : make spectrum absolute flat.\n",
"\n",
"DESCRIPTION:\n",
"     This routine  determines  a  smooth  amplitude  spectrum  of  the\n",
"     signal,  and  then normalizes the signal by the spectrum. Because\n",
"     of the possibility of zeros in the amplitude spectrum,  a  water-\n",
"     level  deconvolution  is  used. The purpose of this routine is to\n",
"     use it prior to bandpass and correlation.\n",
"\n",
"     If Absolute, the spectrum is  not  smoothed,  which  leads  to  a\n",
"     nominally  flat  amplitude  spectrum with some character. Instead\n",
"     the signal has an absolutely flat amplitude spectrum.\n",
"EXAMPLES:\n",
"\n",
"HEADER VALUES SET:\n",
"     USER1 = permin,  USER2=permax,  where  permin=MAX[1.0/filt_f3,old\n",
"     permin]  and  permax=MIN[1./filt_f2,old  permax]. This feature is\n",
"     used by sacmft96 and sacpom96\n",
"DEFAULT:\n",
"     WHITEN FREQlimits -2 -1 1.0e5 1.0e6\n",
"\n",
"\n",
"SEE ALSO\n",
""
};

char *help_write[] = {
"\n",
"\n",
"GSAC Command Reference Manual                               WRITE\n",
"\n",
"SUMMARY:\n",
"     Writes  trace files in memory to disk.\n",
"\n",
"     Write [options] [filelist], where\n",
"\n",
"     where options is one or more of the following:\n",
"\n",
"     [APPEND text ] [ PREPEND text ]\n",
"\n",
"INPUT:\n",
"     APPEND    :  Append  the text to the beginning of all file names.\n",
"     However the leading directory information will  be  stripped  and\n",
"     the file written in the current working directory.\n",
"     PREPEND  : Add the text to the end of all file names. However the\n",
"        leading  directory  information  will be stripped and the file\n",
"        written in the current working directory.\n",
"\n",
"SAC COMPATIBILITY:\n",
"\n",
"     DESCRIPTION: With  no  filelist,  the  original  data  files  are\n",
"     overwritten  by  the current versions in memory. The output order\n",
"     is that in which they were read in and not the way that they  are\n",
"     sorted for display.\n",
"     If   the   filelist   is   given,  there  must  be  a  one-to-one\n",
"        correspondence between the number of traces in memory and  the\n",
"        number of file names in filelist.\n",
"     As  of  August 15, 2007 the APPEND and PREPEND options will write\n",
"        the files in the current directory only.\n",
"     As of July 22, 2009, the APPEND and PREPEND options have no short\n",
"        cuts and must be written exactly.\n",
"\n",
"SEE ALSO\n",
"     WRITEHEADER\n",
""
};

char *help_wh [] = {
"\n",
"\n",
"GSAC Command Reference Manual                         WRITEHEADER\n",
"\n",
"SUMMARY:\n",
"\n",
"     WriteHeader\n",
"\n",
"INPUT:\n",
"\n",
"DESCRIPTION:\n",
"     This overwrites the header information of the corresponding trace\n",
"     files  in memory. The trace information is not overwritten.  This\n",
"     is useful if one wishes to filter traces prior to picking arrival\n",
"     times, but only want to  save  the  arrival  times  and  not  the\n",
"     filtered traces.\n",
"\n",
"SEE ALSO\n",
""
};

char *help_writesp[] = {
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                           WRITESPEC\n",
"\n",
"SUMMARY:\n",
"     Write spectra\n",
"\n",
"     WriteSPec  [options]\n",
"\n",
"     where options are [AM|PH|RL|IM|RLIM|AMPH] [B|O]\n",
"\n",
"INPUT:\n",
"     AMplitude  : output the amplitude spectrum. An .am is appended to\n",
"     the file name\n",
"     PHase      : output the phase spectrum.     A  .ph is appended to\n",
"        the file name\n",
"     ReaL        :  output  the  real  part  of the spectrum. A .rl is\n",
"        appended to the file name\n",
"     IMaginary  : output the imaginary part of the spectrum. A .im  is\n",
"        appended to the file name.\n",
"     RLIM        : output the real and imaginary parts of the spectrum\n",
"        as separate files with .rl and .im  appended.\n",
"     AMPH       : output the amplitude and phase parts of the spectrum\n",
"        as separate files with .am and .ph  appended.\n",
"     B          : Phase is  with  respect  to  the  first  data  point\n",
"        [default]\n",
"     O           :  Phase  is with respect to the O (origin) marker if\n",
"        set\n",
"     Note: more than one option can be  on  the  sommand  line,  e.g.,\n",
"        WRITESP AM RL\n",
"\n",
"DESCRIPTION:\n",
"     The  traces  must have had the command FFT applied. The  spectrum\n",
"     is be written as a trace file with this command. The filename  of\n",
"     the  outfile  will  be  the  same  as  the  trace  file  with  an\n",
"     appropriate identifier appended.\n",
"\n",
"     Note that the FFT may have zero padding. Thus the user  may  have\n",
"     to  do an RMEAN or TAPER before hand. the reason for this caution\n",
"     is that  the  spectrum  will  be  affected  if  the  added  zeros\n",
"     effectively  introduce  a  step  at  the beginning and end of the\n",
"     original treace.\n",
"\n",
"     To distinguish this file from a time series, the following header\n",
"     values are set in the output file: LEVEN = true, IFTYPE = IXY,  B\n",
"     =  0, NPTS = N/2 + 1 where N is the power of two used in the FFT,\n",
"     DELTA = DF where DF = 1/N*DELTA is the frequency  sampling.  Only\n",
"     the  positive  frequencies are output.  The station and component\n",
"     names are preserved.\n",
"\n",
"     All time markers are reset to an uninitialized value  of  -12345.\n",
"     The reference time and date are preserved.\n",
"\n",
"     The  DFT is computed with respect to the first point, e.g., the B\n",
"     value. If the O flag is set, then the DFT is multiplied by exp  [\n",
"     -  i  omega  (B -O) ] to ensure the correct phase with respect to\n",
"     the O marker.\n",
"\n",
"     The resultant files are placed in the current directory.\n",
"SAC COMPATIBILITY:\n",
"\n",
"     DESCRIPTION:\n",
"     As of August 15, 2007 the APPEND and PREPEND options  will  write\n",
"        the files in the current directory only.\n",
"     sac2000  (  [8/8/2001  (Version  00.59.44)]  )  does not have the\n",
"        APPEND and PREPEND options for the spectra.\n",
"\n",
"\n",
"EXAMPLES:\n",
"HEADER VALUES SET:\n",
"     IFTYPE is set to IXY  which means that this is a general xy  plot\n",
"     -  we  use this since sac2000 does not define a frequency series.\n",
"     The IXY flag checked by the PLOT command to  set  the  horizontal\n",
"     axis as frequency. This isnon-standard.\n",
"     LEVEN = true\n",
"\n",
"DEFAULT\n",
"     WRITESPEC AM\n",
"\n",
"SEE ALSO\n",
""
};

char *help_xgrid[] = {
"\n",
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                               XGRID\n",
"\n",
"SUMMARY:\n",
"     Control x-axis grid\n",
"\n",
"     XGRID  [  ON  |  OFF  ] [ Solid | Dotted ]  [ Color int_value ] [\n",
"     Minor ON | OFF ]\n",
"\n",
"INPUT:\n",
"     ON         : turn grid on\n",
"   OFF        : turn grid off\n",
"   Solid      : Use solid line\n",
"   Dashed     : Use dotted line\n",
"   Minor      : connect minor tics too if ON\n",
"   Color int_value : Define the color for the grid. The  figure  frame\n",
"        will continue to be in black. Be careful to select a color not\n",
"        used for the trace.\n",
"DESCRIPTION:\n",
"     This annotates the plots with a grid. Note that the Dotted option\n",
"     is takes more time to plot.\n",
"\n",
"EXAMPLES:\n",
"DEFAULT\n",
"               GRID OFF DOTTED COLOR 1030 MINOR OFF\n",
"   [Note COLOR 1 is black, 2 red, 3 green, 4 blue, 1030 pale yellow ]\n",
"\n",
"SEE ALSO\n",
"     GRID, YGRID, COLOR\n",
""
};

char *help_xlim[] = {
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                                XLIM\n",
"\n",
"SUMMARY:\n",
"     Set time axis limits for trace plot\n",
"\n",
"     XLIM  [ON|OFF]  [  ref  offset  |  GMT  beg  | CAL beg | VEL vref\n",
"     voffsetb  ] [ ref offset | GMT end | CAL end | VEL vref  voffsete\n",
"     ]\n",
"\n",
"\n",
"INPUT:\n",
"     ON                :  Turn  on  plot  limits returning to previous\n",
"     value\n",
"     OFF              : Turn off plot limits\n",
"     ref              : A header reference value for the cut which  is\n",
"        one of B|E|O|A|Tn where n=0,...,9\n",
"     offset            :  Number  of seconds relative to the reference\n",
"        value.  refbeg offset refers to the start point refend  offset\n",
"        refers to the  end  point\n",
"     CAL               :  Calendar  time in YEAR MONTH DAY HOUR MINUTE\n",
"        SECOND MILLISECOND\n",
"     GMT              : GMT time in YEAR DAYOFYEAR HOUR MINUTE  SECOND\n",
"        MILLISECOND\n",
"     VEL       : If O and DIST are set, select a time window about the\n",
"        group velocity vref. Internally input is adjusted so that  the\n",
"        tiem window exists\n",
"\n",
"DESCRIPTION:\n",
"     This  permits user modification of the trace display in PLOT1 and\n",
"     PLOTPK.  One must be careful about the window  because  PLOT1  or\n",
"     PLOTPK can have either ABSOLUTE or RELATIVE plot modes.\n",
"\n",
"     In  the  ABSOLUTE  display  mode,  origin time is one marker that\n",
"     could be In the RELATIVE mode, trace alignment is permitted.  For\n",
"     example,  to look at all marked P-wave first arrivals in relative\n",
"     time, one may try a\n",
"               xlim A -10 A 10\n",
"               plot1 RELATIVE\n",
"     Note that if the ABSOLUTE plot  mode  had  been  used,  then  the\n",
"     display would have the P arrivals in absolute time and they would\n",
"     not be aligned.\n",
"\n",
"     Note  that some combinations, such as xlim A -10 T0 +20, will not\n",
"     have the desired outcome with traces at different distances since\n",
"     the windows are different for each distance. The program will use\n",
"     the common window.\n",
"     The option for CAL or GMT timesd was introduced 11  JAN  2005  to\n",
"        permit selection of time windows from very long time segments.\n",
"        The following are equivalent:\n",
"        XLIM GMT 2005 001 01 02 03 456 GMT 2005 032 06 05 04 321\n",
"        XLIM GMT 2005 001 01 02 03 456 CAL 2005 02 01 06 05 04 321\n",
"        XLIM CAL 2005 01 01 01 02 03 456 GMT 2005 032 06 05 04 321\n",
"        XLIM CAL 2005 01 01 01 02 03 456 CAL 2005 02 01 06 05 04 321\n",
"     which  cuts from January 1, 2005 01:02:03.456 to February 1, 2006\n",
"        06:05:04.321\n",
"\n",
"        The  velocity  cut  was  introduced  to  look  at  a  set   of\n",
"        interstation Green's functions and also to focus on a surface-\n",
"        wave arrival for moment tensor inversion. Some examples are\n",
"     VEL 3.3 -30 VEL 3.3 70\n",
"     which  gives a window 100 seconds long starting 30 seconds before\n",
"        the arrival with a group velocity of 3.3 km/s\n",
"\n",
"SAC COMPATIBILITY:\n",
"Note:\n",
"     The VEL limit will only work in the relative mode. In addition if\n",
"     the start time is before the first sample, the  velocity  display\n",
"     is  not  permitted.   This  is  related to the difficulty of pre-\n",
"     padding with zeros.\n",
"SEE ALSO\n",
"     CUT, PLOT1, PLOTPK\n",
""
};

char *help_xlin [] = {
"\n",
"\n",
"GSAC Command Reference Manual                                XLIN\n",
"\n",
"SUMMARY:\n",
"     Linear x-axis for plot, plotpk\n",
"\n",
"XLIN\n",
"\n",
"INPUT:\n",
"\n",
"DESCRIPTION:\n",
"\n",
"DEFAULT:\n",
"     Linear X-axis\n",
"\n",
"SEE ALSO\n",
"     YLIN, XLOG, YLOG, LINLIN, LINLOG\n",
""
};

char *help_xlog [] = {
"\n",
"\n",
"GSAC Command Reference Manual                                XLOG\n",
"\n",
"SUMMARY:\n",
"     Logarithmic x-axis for plot, plotpk\n",
"\n",
"XLOG\n",
"\n",
"INPUT:\n",
"\n",
"DESCRIPTION:\n",
"\n",
"DEFAULT:\n",
"     Linear x-axis\n",
"\n",
"SEE ALSO\n",
"     XLIN, YLIN, YLOG, LINLIN\n",
""
};

char *help_ygrid[] = {
"\n",
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                               YGRID\n",
"\n",
"SUMMARY:\n",
"     Control y-axis grid\n",
"\n",
"     YGRID  [  ON  |  OFF  ] [ Solid | Dotted ]  [ Color int_value ] [\n",
"     Minor ON | OFF ]\n",
"\n",
"INPUT:\n",
"     ON         : turn grid on\n",
"   OFF        : turn grid off\n",
"   Solid      : Use solid line\n",
"   Dashed     : Use dotted line\n",
"   Minor      : connect minor tics too if ON\n",
"   Color int_value : Define the color for the grid. The  figure  frame\n",
"        will continue to be in black. Be careful to select a color not\n",
"        used for the trace.\n",
"DESCRIPTION:\n",
"     This annotates the plots with a grid. Note that the Dotted option\n",
"     is takes more time to plot.\n",
"\n",
"EXAMPLES:\n",
"DEFAULT\n",
"               GRID OFF DOTTED COLOR 1030 MINOR OFF\n",
"   [Note COLOR 1 is black, 2 red, 3 green, 4 blue, 1030 pale yellow ]\n",
"\n",
"SEE ALSO\n",
"     GRID, XGRID, COLOR\n",
""
};

char *help_ylim[] = {
"\n",
"\n",
"\n",
"GSAC Command Reference Manual                                YLIM\n",
"\n",
"SUMMARY:\n",
"     Define plot limits for y-axis\n",
"\n",
"     YLIM [ALL | OFF | Scale min max ]\n",
"\n",
"INPUT:\n",
"     ALL           : Plot all traces in the current window to the same\n",
"        scale\n",
"     OFF           : Each trace is autoscaled\n",
"     Scale min max : User specified minimum and maximum values\n",
"\n",
"DESCRIPTION:\n",
"     This  option  permits  all traces on a screen to be plotted using\n",
"     the same scale so that the relative differences in amplitude  are\n",
"     obvious. Otherwise each trace is plotted with its own scale.\n",
"\n",
"     The min max in scale can be in scientific notation, e.g.,\n",
"          YLIM SCALE 1.0e-6 2.0e-5\n",
"EXAMPLES:\n",
"\n",
"SAC COMPATIBILITY:\n",
"     Sac  permits  a  PM  v  to  set +- v. It also permits setting the\n",
"     scaling of individual traces in a multitrace plot. GSAC does  not\n",
"     permit either.\n",
"\n",
"     Note  this  command  only affects the time series plots using the\n",
"     command plot1.  It does not affect the  spectra  plot  using  the\n",
"     command plotsp or the record section plot  prs.\n",
"DEFAULT:\n",
"     YLIM OFF\n",
"\n",
"SEE ALSO\n",
""
};

char *help_ylin [] = {
"\n",
"\n",
"GSAC Command Reference Manual                                YLIN\n",
"\n",
"SUMMARY:\n",
"     Linear x-axis for plot, plotpk\n",
"\n",
"YLIN\n",
"\n",
"INPUT:\n",
"\n",
"DESCRIPTION:\n",
"\n",
"DEFAULT:\n",
"     Linear y-axis\n",
"\n",
"SEE ALSO\n",
"     XLIN, XLOG, YLOG, LINLIN, LINLOG\n",
""
};

char *help_ylog [] = {
"\n",
"\n",
"GSAC Command Reference Manual                                YLOG\n",
"\n",
"SUMMARY:\n",
"     Logarithmic y-axis for plot, plotpk\n",
"\n",
"YLOG\n",
"\n",
"INPUT:\n",
"\n",
"DESCRIPTION:\n",
"\n",
"DEFAULT:\n",
"     Linear y-axis\n",
"\n",
"SEE ALSO\n",
"     XLIN, YLIN, XLOG, LINLIN\n",
""
};

