c
c    *****************************************************************
c
c
c   program   r a y p l o t
c   ***********************
c
c   The program rayplot is designed for plotting of ray diagrams,
c   travel times and amplitudes of seismic body waves from the
c   file lu generated by the program ray81 or seis81.
c
c   Modified 3 July 1984 to permit all rays to be plotted at one time
c
c    04 JAN 2021 - change all do XXX yyy ... XXX a=b 
c                  to   do yy ... a=b .. enddo
c           to be compatible with gfortran 9.3
c   ****************************************************************
c
        parameter (LIN=5, LOT=6, LER=0)
        parameter(NLAYER=20, NNODE=20)
        integer NRYSEG
        parameter (NRYSEG=100)
        integer KRAYSG
        parameter (KRAYSG=5000)
        common/intrf/a(NNODE),b(NNODE),c(NNODE),
     1      d(NNODE),x1(NNODE),
     2      brd(2),iii(NNODE),npnt(NLAYER),nint
c-----
c   command stuff
c-----
        logical  ndoxz
        real*4 nxmin, nxmax, nzmin, nzmax
c-----
c   description of ray segments
c-----
        real*4  x(KRAYSG),y(KRAYSG),t(KRAYSG), q(KRAYSG), eta(KRAYSG)
        integer*4 iy(KRAYSG), ips(KRAYSG) 
c-----
c   description of amplitudes for each complete ray
c-----
        integer*4 indi(NRYSEG)
        real*4 ax(NRYSEG), az(NRYSEG)
        logical verbose, ldoray
c-----
c   arrays for initial boundary points
c-----
        real*4 xc(NNODE),zc(NNODE)
        integer*4 ii(NNODE)
        integer*4 nc
c-----
c   array for desired distances
c-----
        integer NDIST
        parameter (NDIST=100)
        integer*4 ndis
        real*4 dist(NDIST)
        character mname*80
c-----
c   ray code description
c-----
        integer*4 ncode, kc, kref, code(NRYSEG)
c-----
c   call machine dependent initialization
c-----
        call mchdep()
c-----
c   read in all control input at once
c-----
        lu = 3
        iprint = 0
        nticx = 5
        nticz = 10
        indo = 0
        xlen = 8.0
        zlen = 6.0
c-----
c   parse command line arguments
c-----
        call gcmdln(verbose,sxmin,sxmax,szmin,szmax,ndoxz)
c-----
        WRITE(6,*)NDOXZ,SXMIN,SXMAX,SZMIN,SZMAX
        if(verbose)then
            iprint = 2
            write(LOT,106)lu,iprint
            write(LOT,106)nticx,nticz,indo
C           write(LOT,102)xmin,xmax,xlen,dticx
C           write(LOT,102)zmin,zmax,zlen,dticz
        endif
c-----
c   initialize the plot
c-----
        call pinitf('CRAY96.PLT')
        open(lu,file='cseis96.trc',access='sequential',
     1      form='unformatted')
        rewind lu
        mname = ' '
        istart = 0
        read(lu)lm
        read(lu)mname(1:lm)
  200   read(lu)icont, nxmin,nxmax,nzmin,nzmax, ldoray
        WRITE(6,*)ICONT,NXMIN,NXMAX,NZMIN,NZMAX
        istart = istart + 1
        if(icont.eq.0)go to 9000
        if(ndoxz)then
            xmax=sxmax
            xmin=sxmin
            zmax=szmax
            zmin=szmin
        else
            xmin = nxmin
            xmax = nxmax
            zmin = nzmin
            zmax = nzmax
        endif
        call maknic(xmin,xmax,xlen,dticx)
        call maknic(zmin,zmax,zlen,dticz)
        WRITE(6,*)XMIN,XMAX,XLEN,DTICX
        WRITE(6,*)ZMIN,ZMAX,ZLEN,DTICZ
        xmer = xlen/(xmax-xmin)
        deltax = 1.0/xmer
        firstx = xmin

        glh = 1.5

        ymin = zmin
        ymax = zmax
        nticy=nticz
        ylen=zlen
        dticy=dticz
        ymer = ylen/(ymax-ymin)
        firstz = ymin
        deltaz = 1.0/ymer
c *************************************************************
        call newpen(1)
c-----
c   Plotting of border for ray diagram
c-----
        if(istart.eq.1)then
            call plot(0.0,0.0, 3)
            call plot(1.5,1.5,-3)
            call gwidth(0.02)
            call border(xlen,dticx,ylen,dticy,glh,1,
     1          xmin,xmax,ymin,ymax,nticx,nticy,mname)
            call newpen(1)
        endif
c-----
c   Plotting of interfaces
c-----
        call newpen(4)
        read(lu)nint,(npnt(i),i=1,nint)
        if(iprint.eq.2)write(LOT,106) nint,(npnt(i),i = 1,nint)
        do 5 i = 1,nint
            n = npnt(i)-1
            read(lu)(a(j),b(j),c(j),d(j),x1(j),iii(j)
     1          ,j = 1,npnt(i))
            if(istart.eq.1)then
                if(iprint.eq.2)then
                write(LOT,*)' '
                write(LOT,105)
     1          (a(j),b(j),c(j),d(j),x1(j),iii(j),j=1,npnt(i))
                endif
                call gwidth(0.01)
c-----
c   compute the original coordinates
c-----
            do 51 j=1,n
                xc(j) = x1(j)
                zc(j) = a(j)
   51       continue
            nc = n + 1
            xc(n+1) = x1(n+1)
            dx = xc(n+1) - xc(n)
            zc(n+1) = a(n)+dx*(b(n)+dx*(c(n)+dx*d(n)))
            xlow = xc(1)
            xhigh = xc(n+1)
            
c-----
c   cycle over X-coordinates
c-----
            do 5100 j=1,nc
                if(j.lt.nc)then
                    dx = (xc(j+1) - xc(j))/10.0
                    do 5105 k=1,11
                        xv = xc(j)+(k-1)*dx
                        x(k) = xv
                        call zofx(xv,z,i,xc,
     1                    zc,nc,ii,nint,xlow,xhigh)
                        y(k) = z
 5105               continue
                    do 5106 k=1,10
                        call rclip(xmin,xmax,ymin,ymax,
     1                  xc1,yc1,xc2,yc2,x,y,k,iplt)
                        if(iplt.gt.0)then
                            xx = (xc1 - xmin)*xmer
                            yy = ylen - (yc1 - ymin)*ymer
                            call plot(xx,yy,3)
                            xx = (xc2 - xmin)*xmer
                            yy = ylen - (yc2 - ymin)*ymer
                            call plot(xx,yy,2)
                        endif
 5106               continue
                endif
                xx = (xc(j) - firstx)/deltax
                yy = ylen - (zc(j) - firstz)/deltaz
                if(xc(j).ge.xmin .and. xc(j).le.xmax
     1              .and. zc(j).ge.ymin
     2              .and. zc(j).le.ymax)then
                if(iii(j).lt.0)then
                    call symbol(xx,yy,0.10,char(2),0.0,-1)
                else
                    call symbol(xx,yy,0.10,char(5),0.0,-1)
                endif
                endif
 5100       continue
            endif
            
    5   continue
c-----
c   reset the line width
c-----
        call gwidth(0.001)
c-----
c   get the coordinates of the source
c-----
        read(lu)x0,y0
        if(iprint.eq.2)write(LOT,102)x0,y0
c-----
c   get desired distances
c-----
        read(lu)ndis
        read(lu)(dist(i),i=1,ndis)
        if(iprint.eq.2)then
            write(LOT,106)ndis
            write(LOT,109)(dist(i),i=1,ndis)
        endif
c-----
c   Plotting of rays
c-----
        call newpen(2)
c-----
c   n   - number of points in ray description
c   ind - success or failure nseis81
c           3 = ray to surface
c   idis    - distance index
c   ncode   - order of ray code from input ray list
c-----
   20   continue
        read(lu)ncode,kc,kref,(code(i),i=1,kref)
        if(verbose)write(LOT,106)ncode,kc,kref,(code(i),i=1,kref)
        if(kref.eq.0)go to 200
   21   read(lu)n,ind,idis,ncode
        ipl = 0
        if(verbose)write(LOT,106)n,ind,idis,ncode
        if(ind.eq.0 .and. idis.eq.0 )go to 24
        if(n.gt.0 .and. ldoray)then
        read(lu)(x(j),y(j),t(j),iy(j),ips(j),q(j),eta(j),j = 1,n)
        else
            go to 21
        endif
        if(iprint.eq.2)then
            write(LOT,113)
            write(LOT,112)
     1      (x(j),y(j),t(j),iy(j),ips(j),q(j),eta(j),j = 1,n)
        endif
c-----
c   plot ray segments
c-----
        do 10 j = 1,n-1
            call rclip(xmin,xmax,ymin,ymax,xc1,yc1,xc2,yc2,
     1          x,y,j,iplt)
            if(iplt.gt.0)then
                xx = (xc1 - xmin)*xmer
                yy = ylen - (yc1 - ymin)*ymer
                call plot(xx,yy,3)
                xx = (xc2 - xmin)*xmer
                yy = ylen - (yc2 - ymin)*ymer
                if(ips(j+1).gt.0)then
                    call plot(xx,yy,2)
                else
                    call newpen(3)
                    call plotd(xx,yy,9,0.05)
                endif
                call plot(xx,yy,2)
                call newpen(2)
            endif
  10    continue
        go to 21
  24    continue
c-----
c   plot the location of the source
c-----
        call newpen(2)
        xnew = x0-xmin
        xnew = xnew*xmer
        ynew = ymax-(y0-ymin)
        ynew = ynew*ymer
        if(x0 .ge. xmin .and. x0.le.xmax .and. 
     1      y0.ge.ymin .and. y0.le.ymax)then
                call symbol(xnew,ynew,0.2,char(1),0.0,-1)
        endif
c-----
c   Plotting of time-distance curve (here get read through the data)
c-----
      read(lu)ns
        if(verbose)write(LOT,106)ns
      if(ns.ne.0) read(lu)(indi(i),x(i),y(i),t(i),ax(i),az(i),i = 1,ns)
        if(verbose)then
        write(LOT,108)(indi(i),x(i),y(i),t(i),ax(i),az(i),i=1,ns)
        endif
c **************************************************************
c
        go to 20
c
c
  102 format(1x,8f10.5)
  105 format(1x,5e12.6,i5)
  106 format(1x,16i5)
  107 format(1x,2x,'end of file')
  108 format(1x,i5,3f10.5,2e15.9)
  109 format(1x,8f10.3)
  112 format(1x,3f11.5,i5,i5,2f11.3)
  113 format(1x,'          X','          Z','          T',
     1 '   IY  IPS          Q        ETA')
        if(verbose)write(LOT,107)
c
c
 9000   continue
        call newpen(1)
        call pend()
      end
c
c   *****************************************************************
c
      subroutine border(glx,gix,gly,giy,glh,n,xmin,xmax,ymin,ymax,
     1  nx,ny,mname)
c-----
c   glx R*4 - length of X-axis
c   gix R*4 - tic interval for X-axis
c   gly R*4 - length of Y-axis
c   giy R*4 - tic interval for Y-axis
c   glh R*4 - character height * 10 also tics
c   n   I*4 - was once control for labels
c   xmin    R*4 - minimum X
c   xmax    R*4 - maximum X
c   ymin    R*4 - minimum Y
c   ymax    R*4 - maximum Y
c   nx  I*4 - number of interior tics for X-axis
c   ny  I*4 - number of interior tics for Y-axis
c   mname   C*80    - model name
c-----
        character mname*80
        lm = lgstr(mname)
      avst = (xmax-xmin)/gix*nx
      val = xmin
      a = glx/avst
      ix = avst
      ggg = glh/10.
      ggh = ggg*1.5
      r = -.1
      call number(r,-.4,.2,val,0.,-1)
      call plot(0.,0.,3)
      do  i = 1,ix
           gi = i
           c = gi*a
           val = val+gix/nx
           if(val.ge.10.) r = -.3
           if(val.ge.100.) r = -.5
           if(val.ge.1000.) r = -.7
           call plot(c,0.,2)
           call plot(c,ggg,2)
           if(i/nx*nx.eq.i)then
                call plot(c,ggh,2)
                call number(c+r,-.4,.2,val,0.,-1)
           endif
           call plot(c,0.,3)
      enddo
      if(n.eq.1) avst = (ymax-ymin)/giy*ny
      b = gly/avst
      iy = avst
      val = ymin
      do  i = 1,iy
           gi = i
           d = gi*b
           call plot(c,d,2)
           call plot(c-ggg,d,2)
           call plot(c,d,3)
      enddo
      do  i = 1,ix
           gi = ix-i
           e = gi*a
           call plot(e,d,2)
           call plot(e,d-ggg,2)
           call plot(e,d,3)
      enddo
      r = -.3
      if(val.lt.0..or.val.ge.10.) r = -0.7
      call number(r,d-0.2,0.2,val,0.,-1)
      call plot(0.,d,3)
      do i = 1,iy
           gi = iy-i
           f = gi*b
           if(n.eq.1) val = val+giy/ny
           if(n.ne.1) val = val-giy/ny
             if(val.lt.10..and.val.ge.0.0)then
                 r = -0.5
             else if(val.lt.0..or.val.ge.10.0)then
                 r = -0.7
             else if(val.le.(-10.).or.val.ge.100.0)then
                 r = -0.9
             else
                 r = -0.3
             endif
           call plot(0.,f,2)
           call plot(ggg,f,2)
           if(i/ny*ny.eq.i)then
               call plot(ggh,f,2)
               call number(r,f-0.1,0.2,val,0.,-1)
           endif
           call plot(0.,f,3)
      enddo
c
c
      ggg = ggg*1.5
      t = c-20.*ggg
      t = t/2.
      call symbol(t,-0.8,ggg,'Distance in km',0.,14)
        call symbol(t,-1.0,0.10,char(2),0.0,-1)
        call symbol(999.0,-1.0,0.10,' - Discontinuous slope',0.0,22)
        call symbol(t,-1.15,0.10,char(5),0.0,-1)
        call symbol(999.0,-1.2,0.10,' - Continuous slope   ',0.0,22)
        call symbol(t+3.0,-1.0,0.10,'P',0.0,1)
        call plot(t+3.2,-1.0,3)
        call plot(t+4.0,-1.0,2)
        call symbol(t+3.0,-1.2,0.10,'S',0.0,1)
        call plot(t+3.2,-1.2,3)
        call plotd(t+4.0,-1.2,9,0.05)
        call symbol(t,-1.4,0.10,mname(1:lm),0.0,lm)
      t = d-17.*ggg
      t = t/2.
      call symbol(-1.2,t,ggg,'Depth in km',90.,11)
      call plot(0.,0.,3)
      return
      end

      subroutine gcmdln(verbose,xmin,xmax,zmin,zmax,ndoxz)
c-----
c   parse command line arguments and return control
c   parameters
c
c   requires subroutine mgtarg(i,name) to return
c       the i'th argument in the string name
c
c   and the function mnmarg() to return the number
c       of arguments excluding program name
c       The first argument is i = 1
c
c-----
c   verbose L   - verbose printer output
c   xmin    R*4 - minimum X value for plot
c   xmax    R*4 - maximum X value for plot
c   zmin    R*4 - minimum Z value for plot
c   zmax    R*4 - maximum Z value for plot
c-----
        logical verbose
        real*4 xmin, xmax, zmin, zmax
        logical ndoxz
        character name*20
c-----
c   set up defaults for poor usage test
c-----
        verbose = .false.
        xmin = 0.0
        xmax = 400.0
        zmin = 0.0
        zmax = 50.0
        ndoxz = .false.
        nmarg = mnmarg()
        i = 0
   11   i = i + 1
        if(i.gt.nmarg)goto 13
            call mgtarg(i,name)
            if(name(1:5).eq.'-xmax'
     1              .or.name(1:5).eq.'-XMAX')then
                i=i+1
                call mgtarg(i,name)
                read(name,'(f20.0)')xmax
                ndoxz = .true.
            else if(name(1:5).eq.'-xmin'
     1              .or.name(1:5).eq.'-XMIN')then
                i=i+1
                call mgtarg(i,name)
                read(name,'(f20.0)')xmin
                ndoxz = .true.
            else if(name(1:5).eq.'-zmax'
     1              .or.name(1:5).eq.'-ZMAX')then
                i=i+1
                call mgtarg(i,name)
                read(name,'(f20.0)')zmax
                ndoxz = .true.
            else if(name(1:5).eq.'-zmin'
     1              .or.name(1:5).eq.'-ZMIN')then
                i=i+1
                call mgtarg(i,name)
                read(name,'(f20.0)')zmin
                ndoxz = .true.
            else if(name(1:2).eq.'-V'.or.name(1:2).eq.'-v')then
                verbose = .true.
            else if(name(1:2) .eq. '-?')then
                call usage(' ')
            else if(name(1:2) .eq. '-h')then
                call usage(' ')
            endif
        go to 11
   13   continue
c-----
c   test for improper command line
c-----
        if(xmin .gt. xmax)then
            tmp = xmin
            xmin = xmax
            xmax = tmp
        endif
        if(zmin .gt. zmax)then
            tmp = zmin
            zmin = zmax
            zmax = tmp
        endif
        if(xmin .eq.xmax)xmax = xmin + 1.0
        if(zmin .eq.zmax)zmax = zmin + 1.0
      return
      end

        

        subroutine usage(ostr)
        integer LIN,LOT,LER
        parameter (LIN=5,LER=0,LOT=6)
        character ostr*(*)
        write(LER,*)
     :'Usage: cray96 -XMIN xmin',
     :' -XMAX xmax -ZMIN zmin -ZMAX zmax -v '
          write(LER,*)
     :' -XMIN [xmin]    (default 0)       : Minimum X for plot'
        write(LER,*)
     :' -XMAX [xmax]    (default=400.0)   : Maximum X for plot'
        write(LER,*)
     :' -ZMIN [zmin]    (default=0.0)     : Minimum Z for plot'
        write(LER,*)
     :' -ZMAX [zmax]    (default = 50.0)  : Maximum Z for plot'
        write(LER,*)
     :' -v      (default = false) : verbose output'
        write(LER,*)
     :' -?      (default = false) : This help screen'
           write(LER,*)
     :' -h      (default = false) : This help screen'
        stop
        end


        subroutine zofx(x,z,layer,xc,zc,nc,ii,mlyr,xlow,xhigh)
c-----
c   using the spline coefficients, compute z(x) for the
c   layer'th layer
c-----
c   For safety if x < xlow, the minimum Z is carried through
c   if x > xhigh, this value of Z is carried through
c-----
c   x   R*4 - input x-coordinate
c   z   R*4 - output z-coordinate
c   layer   I*4 - desired interface
c   xc(NNODE)   R*4 - X coordinate
c   zc(NNODE)   R*4 - Y coordinate
c   nc      I*4 - Number of nodes in the layer NLAYER
c   ii(NNODE)   I*4 - Continuity of Node
c   mlyr            I*4 - Number of Layer Boundaries
c   xlow            R*4 - Smallest Value of xc
c   xhigh           R*4 - Largest  Value of xc
c-----
        parameter (NLAYER=20, NNODE=20, NDIST=100)
        real*4 xc(NNODE), zc(NNODE)
        integer*4 nc, ii(NNODE)
        integer*4 mlyr
        common/intrf/a1(NNODE),b1(NNODE),c1(NNODE),
     1      d1(NNODE),x1(NNODE),
     2      brd(2),iii(NNODE),npnt(NLAYER),nint
c-----
        n = npnt(layer)
        nn = nc
        if(x .lt. xlow)then
            z = zc(1)
        else if(x .ge. xhigh)then
            z =  zc(nn)
        else
            do 100 i=1,n-1
                if(x.ge. x1(i) 
     1              .and. x.lt.x1(i+1))then
                    xdif =  x - x1(i) 
                    z = a1(i) + xdif*(b1(i)
     1                  + xdif*(c1(i) 
     2                  + xdif*(d1(i))))
                    return
                endif
  100       continue
        endif
        return
        end

        subroutine rclip(xmin,xmax,ymin,ymax,xc1,yc1,xc2,yc2,
     1          xc,yc,j,iplt)
c-----
c   perform a line clipping for the plot region
c-----
c   xmin    R*4 - minimum value of X
c   xmax    R*4 - maximum value of X
c   ymin    R*4 - minimum value of Y
c   ymax    R*4 - maximum value of Y
c   xc1 R*4 - coordinate #1 of plotted line segment
c   yc1 R*4
c   xc2 R*4 - coordinate #2 of plotted line segment
c   yc2 R*4
c   xc()    R*4 - array of X-Values
c   yc()    R*4 - array of Y-Values
c   j   I*4 - consider (x,y) between j and j+1
c   iplt    I*4 - > = plot the segment, otherwise do not
c-----
        real*4 xmin, xmax, ymin,ymax
        real*4 xc1, yc1, xc2, yc2
        real*4 xc(*), yc(*)
        integer*4 j
c-----
c   Fortran implementation of Cohen and Sutherland Line Clipping Routine
c-----
        integer c0, c1, c

        iplt = 0
        xx0 = xc(j)
        yz0 = yc(j)
        xx1 = xc(j+1)
        yz1 = yc(j+1)
        call linecode(xx0,yz0,ymax,xmin,ymin,xmax,c0)
        call linecode(xx1,yz1,ymax,xmin,ymin,xmax,c1)
        if( xx0 .ne. xx1)slope = (yz1-yz0)/(xx1-xx0)
        if( yz0 .ne. yz1) slopeinv = (xx1-xx0)/(yz1-yz0)
 1000   continue
        if(c0 .eq. 0 .and. c1 .eq.0)go to 1001
            if( (mod(c0,2).eq.1 .and. mod(c1,2).eq.1).or.
     1      (mod(c0/2,2).eq.1 .and. mod(c1/2,2).eq.1).or.
     2      (mod(c0/4,2).eq.1 .and. mod(c1/4,2).eq.1).or.
     3      (mod(c0/8,2).eq.1 .and. mod(c1/8,2).eq.1))return

                if(c0 .eq. c1) return 
                if(c0 .eq. 0 )then
                        c = c1
                else 
                        c = c0
            endif
                if(mod(c,2).eq.1)then
                        y = yz0 + slope*(xmin-xx0)
                        x = xmin
                endif
                if(mod(c/2,2).eq.1)then 
                y = yz0 + slope*(xmax-xx0)
                        x = xmax
                endif
                if(mod(c/8,2).eq.1)then
                        x = slopeinv*(ymax-yz0) + xx0
                        y = ymax
                endif
                if(mod(c/4,2).eq.1)then
                        x = slopeinv*(ymin-yz0) + xx0
                        y = ymin
                endif
                if(c .eq. c0)then
                        xx0 = x
                        yz0 = y
                call linecode(xx0,yz0,ymax,xmin,ymin,xmax,c0)
                else 
                        xx1 = x
                        yz1 = y
                call linecode(xx1,yz1,ymax,xmin,ymin,xmax,c1)
                endif
        go to 1000
 1001   continue
        xc1 = xx0
        xc2 = xx1
        yc1 = yz0
        yc2 = yz1
        iplt = 1
        return
        end
c   
        subroutine linecode(x,y,ymax,xmin,ymin,xmax,c)
        real*4 x, y, ymax, xmin, ymin, xmax
        integer*4 c
        c = 0

        if(x .lt. xmin) then
            c = 1
        else if(x .gt. xmax)then
            c = 2
        endif
        if(y .lt. ymin) then
            c = c + 4
        else if(y.gt.ymax)then
            c = c + 8
        endif
        return
        end

        subroutine maknic(xmin,xmax,xlen,dticx)
c-----
c   modify user input for a nicer set of plot
c   coordinates, e.g., 11 becomes 10
c-----

        dx = (xmax-xmin)/xlen
        if(dx.eq.0.0)dx = 1.0
c-----
c   assume dx > 0
c-----
        alx = alog10(dx)
        if(alx .ge. 0.0)then
            ilx = alx
        else
            ilx = alx -1.0
        endif
c-----
c   ilx is the power of dx
c
c   dx = X 10**ilx
c-----  
        x = dx/10.0**ilx
        if(x.ge. 10.0)then
            x = x / 10.0
            ilx = ilx + 1
        endif
        if(x.lt. 1.0)then
            x = x * 10.0
            ilx = ilx - 1
        endif
c-----
c   now make x some nice number
c-----
        if(x.ge.1.0 .and. x.lt.2.0)then
            x = 1.0
        else if(x.ge.2.0 .and. x.lt.2.5)then
            x = 2.0
        else if(x.ge.2.5 .and. x.lt.5.0)then
            x = 2.5
        else if(x.ge.5.0)then
            x = 5.0
        endif
c-----
c   define the new dx
c-----
        dx = x* 10.0**ilx
        dticx = dx
c-----
c   now modify the starting and end values
c-----
        il = xmin/dx
        if(abs(il*dx-xmin).gt.0.001*xmin)then
            if(xmin.lt.0.0)then
                xmin = (il-1)*dx
            else
                xmin = il*dx
            endif
        endif
        il = xmax/dx
        if(abs(il*dx-xmax).gt.0.001*xmax)then
            if(xmax.lt.0.0)then
                xmax = il*dx
            else
                xmax = (il+1)*dx
            endif
        endif
        return
        end

