/* File>>> charcodes.h
--
-- %M% -- version %I% (IMEC)            last updated: %E%
--
-- Copyright (c) 1993
-- IMEC vzw
-- Kapeldreef 75
-- B-3001 LEUVEN
-- BELGIUM
--
-- Author   : A. Demaree
--
-- Date     : June 23, 1993
--
-- Function : Definition of the array containing the coordinates of
--            all printable characters (ASCII code 32 to 126).
--
-- Comment  :
--
-- Review   :
--
*/


#ifndef __CHARCODES_H
#define __CHARCODES_H


/*
-- The coordinates for the characters
-- Syntax :  nr-of-polygons, nr-of-coordinates, x1,y1, x2,y2, ....., xn,yn,
--                           nr-of-coordinates, x1,y1, x2,y2, ....., xn,yn,
--                           ................
--                           ..........
--           nr-of-polygons, nr-of-coordinates, x1,y1, x2,y2, ....., xn,yn,
--                           nr-of-coordinates, x1,y1, x2,y2, ....., xn,yn,
--                           ................
--                           ..........
--           .....................
--           .............
*/

static int charcode[1559] = {
  /*   */   0,
  /* ! */   2,  2, 3,6, 3,1,
                2, 3,0, 3,0,
  /* " */   2,  2, 2,6, 2,4,
                2, 4,6, 4,4,
  /* # */   4,  2, 2,6, 2,0,
                2, 4,6, 4,0,
                2, 1,4, 5,4,
                2, 1,2, 5,2,
  /* $ */   2,  6, 1,1, 5,1, 5,3, 1,3, 1,5, 5,5,
                2, 3,6, 3,0,
  /* % */   3,  5, 1,5, 1,6, 3,6, 3,5, 1,5,
                2, 1,1, 5,5,
                5, 3,0, 3,1, 5,1, 5,0, 3,0,
  /* & */   1, 11, 5,0, 1,4, 1,5, 2,6, 3,5, 3,4, 1,2, 1,1, 2,0, 3,0, 5,2,
  /* ' */   1,  3, 3,6, 3,5, 2,4,
  /* ( */   1,  6, 4,0, 3,0, 2,1, 2,5, 3,6, 4,6,
  /* ) */   1,  6, 2,0, 3,0, 4,1, 4,5, 3,6, 2,6,
  /* * */   3,  2, 1,1, 5,5,
                2, 5,1, 1,5,
                2, 1,3, 5,3,
  /* + */   2,  2, 1,3, 5,3,
                2, 3,5, 3,1,
  /* , */   1,  3, 3,1, 3,0, 2,-1,
  /* - */   1,  2, 1,3, 5,3,
  /* . */   1,  2, 3,0, 3,0,
  /* / */   1,  2, 1,1, 5,5,
  /* 0 */   2,  9, 1,1, 1,5, 2,6, 4,6, 5,5, 5,1, 4,0, 2,0, 1,1,
                2, 1,1, 5,5,
  /* 1 */   2,  2, 1,0, 5,0,
                3, 2,5, 3,6, 3,0,
  /* 2 */   1,  7, 1,5, 2,6, 4,6, 5,5, 5,4, 1,0, 5,0,
  /* 3 */   2,  7, 1,5, 2,6, 4,6, 5,5, 5,4, 4,3, 2,3,
                6, 4,3, 5,2, 5,1, 4,0, 2,0, 1,1,
  /* 4 */   1,  4, 5,3, 1,3, 4,6, 4,0,
  /* 5 */   1,  9, 1,1, 2,0, 4,0, 5,1, 5,3, 4,4, 1,4, 1,6, 5,6,
  /* 6 */   1, 12, 1,2, 2,3, 4,3, 5,2, 5,1, 4,0, 2,0, 1,1, 1,5, 2,6, 4,6, 5,5,
  /* 7 */   1,  5, 2,0, 2,2, 5,5, 5,6, 1,6,
  /* 8 */   1, 16, 2,3, 1,2, 1,1, 2,0, 4,0, 5,1, 5,2, 4,3, 2,3, 1,4, 1,5, 2,6,
                   4,6, 5,5, 5,4, 4,3,
  /* 9 */   1, 12, 5,4, 4,3, 2,3, 1,4, 1,5, 2,6, 4,6, 5,5, 5,1, 4,0, 2,0, 1,1,
  /* : */   2,  2, 3,3, 3,3,
                2, 3,1, 3,1,
  /* ; */   2,  2, 3,3, 3,3,
                3, 3,1, 3,0, 2,-1,
  /* < */   1,  3, 4,1, 2,3, 4,5,
  /* = */   2,  2, 1,2, 5,2,
                2, 1,4, 5,4,
  /* > */   1,  3, 2,1, 4,3, 2,5,
  /* ? */   2,  8, 1,4, 1,5, 2,6, 4,6, 5,5, 5,4, 3,2, 3,1,
                2, 3,0, 3,0,
  /* @ */   2,  8, 5,0, 2,0, 1,1, 1,5, 2,6, 4,6, 5,5, 5,1,
                8, 5,2, 4,1, 3,1, 2,2, 2,4, 3,5, 4,5, 5,4,
  /* A */   2,  6, 1,0, 1,5, 2,6, 4,6, 5,5, 5,0,
                2, 1,3, 5,3,
  /* B */   1, 11, 1,3, 4,3, 5,2, 5,1, 4,0, 1,0, 1,6, 4,6, 5,5, 5,4, 4,3,
  /* C */   1,  8, 5,5, 4,6, 2,6, 1,5, 1,1, 2,0, 4,0, 5,1,
  /* D */   1,  7, 1,0, 1,6, 4,6, 5,5, 5,1, 4,0, 1,0,
  /* E */   2,  4, 5,6, 1,6, 1,0, 5,0,
                2, 1,3, 4,3,
  /* F */   2,  3, 5,6, 1,6, 1,0,
                2, 1,3, 4,3,
  /* G */   1, 10, 5,5, 4,6, 2,6, 1,5, 1,1, 2,0, 4,0, 5,1, 5,3, 3,3,
  /* H */   3,  2, 1,6, 1,0,
                2, 1,3, 5,3,
                2, 5,6, 5,0,
  /* I */   3,  2, 1,6, 5,6,
                2, 3,6, 3,0,
                2, 1,0, 5,0,
  /* J */   1,  5, 1,1, 2,0, 4,0, 5,1, 5,6,
  /* K */   3,  2, 1,6, 1,0,
                2, 1,2, 5,6,
                2, 2,3, 5,0,
  /* L */   1,  3, 1,6, 1,0, 5,0,
  /* M */   1,  5, 1,0, 1,6, 3,4, 5,6, 5,0,
  /* N */   2,  3, 1,0, 1,6, 5,2,
                2, 5,0, 5,6,
  /* O */   1,  9, 1,1, 1,5, 2,6, 4,6, 5,5, 5,1, 4,0, 2,0, 1,1,
  /* P */   1,  7, 1,0, 1,6, 4,6, 5,5, 5,4, 4,3, 1,3,
  /* Q */   2,  9, 1,1, 1,5, 2,6, 4,6, 5,5, 5,1, 4,0, 2,0, 1,1,
                2, 4,1, 5,0,
  /* R */   2,  7, 1,0, 1,6, 4,6, 5,5, 5,4, 4,3, 1,3,
                2, 2,3, 5,0,
  /* S */   1, 12, 1,1, 2,0, 4,0, 5,1, 5,2, 4,3, 2,3, 1,4, 1,5, 2,6, 4,6, 5,5,
  /* T */   2,  2, 1,6, 5,6,
                2, 3,6, 3,0,
  /* U */   1,  6, 1,6, 1,1, 2,0, 4,0, 5,1, 5,6,
  /* V */   1,  5, 1,6, 1,2, 3,0, 5,2, 5,6,
  /* W */   2,  5, 1,6, 1,1, 2,0, 3,1, 3,6,
                4, 5,6, 5,1, 4,0, 3,1,
  /* X */   2,  4, 1,6, 1,5, 5,1, 5,0,
                4, 1,0, 1,1, 5,5, 5,6,
  /* Y */   2,  4, 1,6, 1,5, 3,3, 3,0,
                3, 3,3, 5,5, 5,6,
  /* Z */   1,  8, 1,5, 1,6, 5,6, 5,5, 1,1, 1,0, 5,0, 5,1,
  /* [ */   1,  4, 4,0, 2,0, 2,6, 4,6,
  /* \ */   1,  2, 1,5, 5,1,
  /* ] */   1,  4, 2,0, 4,0, 4,6, 2,6,
  /* ^ */   1,  3, 1,4, 3,6, 5,4,
  /* _ */   1,  2, 1,0, 5,0,
  /* ` */   1,  3, 3,6, 3,5, 4,4,
  /* a */   2,  8, 5,1, 4,0, 2,0, 1,1, 1,2, 2,3, 4,3, 5,2,
                4, 5,0, 5,3, 4,4, 2,4,
  /* b */   2,  2, 1,6, 1,0,
                8, 1,3, 2,4, 4,4, 5,3, 5,1, 4,0, 2,0, 1,1,
  /* c */   1,  8, 5,1, 4,0, 2,0, 1,1, 1,3, 2,4, 4,4, 5,3,
  /* d */   2,  8, 5,3, 4,4, 2,4, 1,3, 1,1, 2,0, 4,0, 5,1,
                2, 5,0, 5,6,
  /* e */   1, 10, 5,1, 4,0, 2,0, 1,1, 1,3, 2,4, 4,4, 5,3, 5,2, 1,2,
  /* f */   2,  5, 2,0, 2,5, 3,6, 4,6, 5,5,
                2, 1,3, 3,3,
  /* g */   2,  8, 5,1, 4,0, 2,0, 1,1, 1,3, 2,4, 4,4, 5,3,
                5, 5,4, 5,-1, 4,-2, 2,-2, 1,-1,
  /* h */   2,  2, 1,0, 1,6,
                5, 1,3, 2,4, 4,4, 5,3, 5,0,
  /* i */   3,  2, 1,0, 5,0,
                3, 3,0, 3,4, 2,4,
                2, 3,5, 3,5,
  /* j */   2,  5, 1,-1, 2,-2, 4,-2, 5,-1, 5,4,
                2, 5,5, 5,5,
  /* k */   3,  2, 1,0, 1,6,
                2, 1,2, 3,4,
                2, 2,3, 5,0,
  /* l */   2,  2, 1,0, 5,0,
                3, 3,0, 3,6, 2,6,
  /* m */   3,  2, 1,0, 1,4,
                4, 1,3, 2,4, 3,3, 3,0,
                4, 3,3, 4,4, 5,3, 5,0,
  /* n */   2,  2, 1,0, 1,4,
                5, 1,3, 2,4, 4,4, 5,3, 5,0,
  /* o */   1,  9, 1,1, 1,3, 2,4, 4,4, 5,3, 5,1, 4,0, 2,0, 1,1,
  /* p */   2,  2, 1,-2, 1,4,
                8, 1,3, 2,4, 4,4, 5,3, 5,1, 4,0, 2,0, 1,1,
  /* q */   2,  2, 5,-2, 5,4,
                8, 5,3, 4,4, 2,4, 1,3, 1,1, 2,0, 4,0, 5,1,
  /* r */   2,  2, 1,0, 1,4,
                4, 1,3, 2,4, 4,4, 5,3,
  /* s */   1,  8, 1,0, 4,0, 5,1, 4,2, 2,2, 1,3, 2,4, 4,4,
  /* t */   2,  2, 1,4, 3,4,
                5, 2,5, 2,1, 3,0, 4,0, 5,1,
  /* u */   1,  6, 1,4, 1,1, 2,0, 4,0, 5,1, 5,4,
  /* v */   1,  5, 1,4, 1,2, 3,0, 5,2, 5,4,
  /* w */   2,  5, 1,4, 1,1, 2,0, 3,1, 3,4,
                4, 3,1, 4,0, 5,1, 5,4,
  /* x */   2,  2, 1,0, 5,4,
                2, 1,4, 5,0,
  /* y */   2,  5, 1,4, 1,1, 2,0, 4,0, 5,1,
                5, 5,4, 5,-1, 4,-2, 2,-2, 1,-1,
  /* z */   1,  4, 1,4, 5,4, 1,0, 5,0,
  /* { */   2,  2, 1,3, 2,3,
                6, 4,6, 3,6, 2,5, 2,1, 3,0, 4,0,
  /* | */   2,  2, 3,6, 3,4,
                2, 3,2, 3,0,
  /* } */   2,  6, 2,6, 3,6, 4,5, 4,1, 3,0, 2,0,
                2, 4,3, 5,3,
  /* ~ */   1,  4, 1,5, 2,6, 4,4, 5,5 };


/*
-- The indices in the previous array where a particular character starts
*/

static int charpointer[95] = {     /* 32..126 */
  0,1,12,23,44,63,91,115,123,137,151,167,178,186,192,198,
  204,229,242,258,287,297,317,343,355,389,415,426,439,447,458,
  466,489,524,543,567,585,601,616,629,651,667,683,695,711,
  719,731,744,764,780,805,826,852,863,877,889,910,929,946,964,
  974,980,990,998,1004,1012,1039,1062,1080,1103,1125,1142,1171,1188,
  1206,1223,1239,1252,1276,1293,1313,1336,1359,1374,1392,1409,
  1423,1435,1456,1467,1490,1500,1519,1530,1549 };


#endif  /* __CHARCODES_H */
